/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree;

import dr.evolution.coalescent.IntervalType;
import dr.evolution.coalescent.TreeIntervalList;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.util.ComparableDouble;
import dr.util.HeapSort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BigFastTreeIntervals
extends AbstractModel
implements Units,
TreeIntervalList {
    private Units.Type units = Units.Type.GENERATIONS;
    protected final Events events;
    private final Events storedEvents;
    protected List<Integer> updatedNodes;
    private List<Integer> storedUpdatedNodes;
    protected boolean intervalsKnown;
    private boolean storedIntervalsKnown;
    protected boolean onlyUpdateTimes;
    private boolean storedOnlyUpdateTimes;
    private final TreeModel tree;
    protected boolean dirty;
    private int intervalCount = 0;

    public BigFastTreeIntervals(TreeModel treeModel) {
        this("bigFastIntervals", treeModel);
    }

    public BigFastTreeIntervals(String string, TreeModel treeModel) {
        super(string);
        int n = treeModel.getNodeCount();
        this.tree = treeModel;
        this.intervalsKnown = false;
        this.updatedNodes = new ArrayList<Integer>(n);
        this.storedUpdatedNodes = new ArrayList<Integer>(n);
        this.events = new Events(n);
        this.storedEvents = new Events(n);
        this.dirty = true;
        this.onlyUpdateTimes = false;
        this.calculateIntervals();
        this.addModel(treeModel);
    }

    public void makeDirty() {
        this.dirty = true;
        this.intervalsKnown = false;
    }

    @Override
    public int getIntervalCount() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervalCount;
    }

    @Override
    public int getSampleCount() {
        return this.tree.getTaxonCount();
    }

    @Override
    public double getStartTime() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.events.getTime(0);
    }

    @Override
    public double getInterval(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.events.getInterval(n + 1);
    }

    public int getIntervalIndexForNode(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.events.getNodePosition(n);
    }

    @Override
    public double getIntervalTime(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.events.getTime(n);
    }

    @Override
    public int getLineageCount(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.events.getLineageCount(n + 1);
    }

    @Override
    public int getCoalescentEvents(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        if (n < this.intervalCount - 1) {
            return this.events.getLineageCount(n + 1) - this.events.getLineageCount(n + 2);
        }
        return this.events.getLineageCount(n + 1) - 1;
    }

    @Override
    public IntervalType getIntervalType(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.events.getType(n + 1);
    }

    @Override
    public double getTotalDuration() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.events.getTime(this.events.size() - 1);
    }

    @Override
    public boolean isBinaryCoalescent() {
        return true;
    }

    @Override
    public boolean isCoalescentOnly() {
        return true;
    }

    @Override
    public int[] getIntervalsForNode(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = this.events.getNodePosition(n);
        if (n4 > 0) {
            n2 = n4 - 1;
            if (n4 < this.intervalCount) {
                n3 = n4;
            }
        } else {
            n2 = 0;
        }
        int[] nArray = n3 == -1 ? new int[]{n2} : new int[]{n2, n3};
        return nArray;
    }

    @Override
    public int[] getNodeNumbersForInterval(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        int[] nArray = new int[]{this.events.getNode(n), this.events.getNode(n + 1)};
        return nArray;
    }

    @Override
    public boolean isBuildIntervalNodeMapping() {
        return true;
    }

    @Override
    public NodeRef getCoalescentNode(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        if (this.events.getType(n + 1) != IntervalType.COALESCENT) {
            throw new IllegalArgumentException("interval is not a coalescent interval");
        }
        return this.tree.getNode(this.events.getNode(n + 1));
    }

    public NodeRef getSamplingNode(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        if (this.events.getType(n + 1) != IntervalType.SAMPLE) {
            throw new IllegalArgumentException("interval is not a sampling interval");
        }
        return this.tree.getNode(this.events.getNode(n + 1));
    }

    @Override
    public double[] sortByNodeNumbers(double[] dArray) {
        int n;
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        double[] dArray2 = new double[dArray.length];
        int[] nArray = new int[dArray.length];
        ArrayList<ComparableDouble> arrayList = new ArrayList<ComparableDouble>();
        for (n = 0; n < nArray.length; ++n) {
            arrayList.add(new ComparableDouble(this.getIntervalsForNode(n + this.tree.getExternalNodeCount())[0]));
        }
        HeapSort.sort(arrayList, nArray);
        for (n = 0; n < nArray.length; ++n) {
            dArray2[nArray[n]] = dArray[n];
        }
        return dArray2;
    }

    @Override
    public double[] getCoalescentIntervals() {
        double[] dArray = new double[this.tree.getInternalNodeCount()];
        int n = 0;
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.getIntervalType(i) != IntervalType.COALESCENT) continue;
            dArray[n] = this.getInterval(i);
            ++n;
        }
        return dArray;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public void calculateIntervals() {
        if (this.dirty) {
            NodeRef[] nodeRefArray = new NodeRef[this.tree.getNodeCount()];
            System.arraycopy(this.tree.getNodes(), 0, nodeRefArray, 0, this.tree.getNodeCount());
            Arrays.parallelSort(nodeRefArray, (nodeRef, nodeRef2) -> Double.compare(this.tree.getNodeHeight((NodeRef)nodeRef), this.tree.getNodeHeight((NodeRef)nodeRef2)));
            this.intervalCount = nodeRefArray.length - 1;
            double d = this.tree.getNodeHeight(nodeRefArray[0]);
            if (!this.tree.isExternal(nodeRefArray[0])) {
                throw new IllegalArgumentException("The first event is not a sample event");
            }
            this.events.setEvent(d, IntervalType.SAMPLE, nodeRefArray[0].getNumber(), 0.0, -1, 0);
            int n = 1;
            for (int i = 1; i < nodeRefArray.length; ++i) {
                NodeRef nodeRef3 = nodeRefArray[i];
                double d2 = this.tree.getNodeHeight(nodeRef3);
                double d3 = d2 - d;
                IntervalType intervalType = this.tree.isExternal(nodeRef3) ? IntervalType.SAMPLE : IntervalType.COALESCENT;
                int n2 = n++;
                this.events.setEvent(d2, intervalType, nodeRef3.getNumber(), d3, n2, i);
                this.events.setNodeOrder(nodeRef3.getNumber(), i);
                if (intervalType != IntervalType.SAMPLE) {
                    --n;
                }
                d = d2;
            }
            this.intervalsKnown = true;
        } else if (this.onlyUpdateTimes) {
            for (int i = 0; i < this.events.size(); ++i) {
                double d = this.tree.getNodeHeight(this.tree.getNode(this.events.getNode(i)));
                this.events.updateEventTime(d, i);
            }
            this.onlyUpdateTimes = false;
        } else {
            for (int n : this.updatedNodes) {
                this.events.updateForChangedNode(n, this.tree.getNodeHeight(this.tree.getNode(n)));
            }
        }
        this.intervalsKnown = true;
        this.dirty = false;
        this.updatedNodes = new ArrayList<Integer>();
    }

    @Override
    public final Units.Type getUnits() {
        return this.units;
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.units = type;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree) {
            if (object instanceof TreeChangedEvent) {
                TreeChangedEvent treeChangedEvent = (TreeChangedEvent)object;
                if (treeChangedEvent.isNodeChanged()) {
                    if (treeChangedEvent.isHeightChanged()) {
                        NodeRef nodeRef = ((TreeChangedEvent)object).getNode();
                        this.updatedNodes.add(nodeRef.getNumber());
                        this.intervalsKnown = false;
                    }
                } else if (treeChangedEvent.isTreeChanged()) {
                    if (!treeChangedEvent.isNodeOrderChanged()) {
                        this.onlyUpdateTimes = true;
                        this.intervalsKnown = false;
                    } else {
                        this.makeDirty();
                    }
                }
            }
            this.fireModelChanged(object);
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        this.storedUpdatedNodes = new ArrayList<Integer>();
        this.storedUpdatedNodes.addAll(this.updatedNodes);
        this.storedIntervalsKnown = this.intervalsKnown;
        this.storedEvents.copyEvents(this.events);
        this.storedOnlyUpdateTimes = this.onlyUpdateTimes;
    }

    @Override
    protected void restoreState() {
        List<Integer> list = this.storedUpdatedNodes;
        this.storedUpdatedNodes = this.updatedNodes;
        this.updatedNodes = list;
        this.events.copyEvents(this.storedEvents);
        this.intervalsKnown = this.storedIntervalsKnown;
        this.onlyUpdateTimes = this.storedOnlyUpdateTimes;
    }

    @Override
    protected void acceptState() {
    }

    protected class Events {
        private final int[] nodes;
        private final int[] nodeOrder;
        private final int[] lineageCounts;
        private final double[] intervals;
        private final double[] times;
        private final IntervalType[] intervalTypes;
        private final int numberOfEvents;

        public Events(int n) {
            this.nodes = new int[n];
            this.nodeOrder = new int[n];
            this.lineageCounts = new int[n];
            this.intervals = new double[n];
            this.times = new double[n];
            this.intervalTypes = new IntervalType[n];
            this.numberOfEvents = n;
        }

        public int getNodePosition(int n) {
            return this.nodeOrder[n];
        }

        public IntervalType getType(int n) {
            return this.intervalTypes[n];
        }

        public double getTime(int n) {
            return this.times[n];
        }

        public int size() {
            return this.numberOfEvents;
        }

        public void setEvent(double d, IntervalType intervalType, int n, double d2, int n2, int n3) {
            this.times[n3] = d;
            this.intervalTypes[n3] = intervalType;
            this.nodes[n3] = n;
            this.intervals[n3] = d2;
            this.lineageCounts[n3] = n2;
        }

        public void updateForChangedNode(int n, double d) {
            int n2;
            int n3 = this.nodeOrder[n];
            double d2 = this.times[n3];
            int n4 = n3;
            if (d > d2) {
                n2 = this.findFirstGreater(this.times, d, n3, this.numberOfEvents - 1);
                n4 = n2 - 1;
            } else if (d < d2) {
                n4 = this.findFirstGreater(this.times, d, 0, n3 - 1);
            }
            if (n4 != n3) {
                int n5;
                n2 = this.lineageCounts[n3];
                double d3 = this.intervals[n3];
                double d4 = this.times[n3];
                IntervalType intervalType = this.intervalTypes[n3];
                if (n4 > n3) {
                    n5 = n4 - n3;
                    System.arraycopy(this.intervals, n3 + 1, this.intervals, n3, n5);
                    System.arraycopy(this.times, n3 + 1, this.times, n3, n5);
                    System.arraycopy(this.intervalTypes, n3 + 1, this.intervalTypes, n3, n5);
                    System.arraycopy(this.nodes, n3 + 1, this.nodes, n3, n5);
                    System.arraycopy(this.lineageCounts, n3 + 1, this.lineageCounts, n3, n5);
                } else {
                    n5 = n3 - n4;
                    System.arraycopy(this.intervals, n4, this.intervals, n4 + 1, n5);
                    System.arraycopy(this.times, n4, this.times, n4 + 1, n5);
                    System.arraycopy(this.intervalTypes, n4, this.intervalTypes, n4 + 1, n5);
                    System.arraycopy(this.nodes, n4, this.nodes, n4 + 1, n5);
                    System.arraycopy(this.lineageCounts, n4, this.lineageCounts, n4 + 1, n5);
                }
                this.lineageCounts[n4] = n2;
                this.intervals[n4] = d3;
                this.times[n4] = d4;
                this.intervalTypes[n4] = intervalType;
                this.nodes[n4] = n;
                for (n5 = Math.min(n3, n4); n5 < Math.max(n3, n4) + 1; ++n5) {
                    this.nodeOrder[this.nodes[n5]] = n5;
                }
                if (this.intervalTypes[n4] == IntervalType.COALESCENT) {
                    int n6 = n5 = this.intervalTypes[n4 - 1] == IntervalType.COALESCENT ? -1 : 1;
                    if (n4 > n3) {
                        int n7 = n3;
                        while (n7 < n4) {
                            int n8 = n7++;
                            this.lineageCounts[n8] = this.lineageCounts[n8] + 1;
                        }
                        this.lineageCounts[n4] = this.lineageCounts[n4 - 1] + n5;
                    } else {
                        this.lineageCounts[n4] = this.lineageCounts[n4 - 1] + n5;
                        int n9 = n4 + 1;
                        while (n9 < n3 + 1) {
                            int n10 = n9++;
                            this.lineageCounts[n10] = this.lineageCounts[n10] - 1;
                        }
                    }
                } else if (n4 > n3) {
                    n5 = this.intervalTypes[n4 - 1] == IntervalType.COALESCENT ? -1 : 1;
                    int n11 = n3;
                    while (n11 < n4) {
                        int n12 = n11++;
                        this.lineageCounts[n12] = this.lineageCounts[n12] - 1;
                    }
                    this.lineageCounts[n4] = this.lineageCounts[n4 - 1] + n5;
                } else {
                    if (n4 == 0) {
                        this.lineageCounts[n4] = 0;
                    } else {
                        n5 = this.intervalTypes[n4 - 1] == IntervalType.COALESCENT ? -1 : 1;
                        this.lineageCounts[n4] = this.lineageCounts[n4 - 1] + n5;
                    }
                    n5 = n4 + 1;
                    while (n5 < n3 + 1) {
                        int n13 = n5++;
                        this.lineageCounts[n13] = this.lineageCounts[n13] + 1;
                    }
                }
                this.updateTimeAndIntervals(this.times[n3], n3);
            }
            this.updateTimeAndIntervals(d, n4);
        }

        public void copyEvents(Events events) {
            System.arraycopy(events.nodeOrder, 0, this.nodeOrder, 0, this.numberOfEvents);
            System.arraycopy(events.nodes, 0, this.nodes, 0, this.numberOfEvents);
            System.arraycopy(events.times, 0, this.times, 0, this.numberOfEvents);
            System.arraycopy(events.lineageCounts, 0, this.lineageCounts, 0, this.numberOfEvents);
            System.arraycopy(events.intervalTypes, 0, this.intervalTypes, 0, this.numberOfEvents);
            System.arraycopy(events.intervals, 0, this.intervals, 0, this.numberOfEvents);
        }

        private int findFirstGreater(double[] dArray, double d, int n, int n2) {
            int n3 = n;
            int n4 = n2;
            int n5 = -1;
            while (n3 <= n4) {
                int n6 = (n3 + n4) / 2;
                if (dArray[n6] <= d) {
                    n3 = n6 + 1;
                    continue;
                }
                n5 = n6;
                n4 = n6 - 1;
            }
            if (n5 == -1) {
                n5 = n2 + 1;
            }
            return n5;
        }

        public int getNode(int n) {
            return this.nodes[n];
        }

        public void updateTimeAndIntervals(double d, int n) {
            double d2 = n == 0 ? -1.0 : d - this.times[n - 1];
            this.times[n] = d;
            this.intervals[n] = d2;
            if (n < this.numberOfEvents - 1) {
                double d3;
                this.intervals[n + 1] = d3 = this.times[n + 1] - d;
            }
        }

        public void updateEventTime(double d, int n) {
            double d2 = n == 0 ? -1.0 : d - this.times[n - 1];
            this.times[n] = d;
            this.intervals[n] = d2;
        }

        public int getLineageCount(int n) {
            return this.lineageCounts[n];
        }

        public double getInterval(int n) {
            return this.intervals[n];
        }

        public void setNodeOrder(int n, int n2) {
            this.nodeOrder[n] = n2;
        }
    }
}

