/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.bigfasttree.thorney.ConstrainableTreeOperator;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;

public class NNI
extends AbstractTreeOperator
implements ConstrainableTreeOperator {
    private TreeModel tree = null;

    public NNI(TreeModel treeModel, double d) {
        this.tree = treeModel;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        return this.doOperation(this.tree);
    }

    @Override
    public double doOperation(TreeModel treeModel) {
        double d;
        NodeRef nodeRef;
        int n = treeModel.getNodeCount();
        NodeRef nodeRef2 = treeModel.getRoot();
        while (nodeRef2 == (nodeRef = treeModel.getNode(MathUtils.nextInt(n))) || treeModel.getParent(nodeRef) == nodeRef2) {
        }
        NodeRef nodeRef3 = treeModel.getParent(nodeRef);
        NodeRef nodeRef4 = treeModel.getParent(nodeRef3);
        NodeRef nodeRef5 = treeModel.getChild(nodeRef4, 0);
        if (nodeRef5 == nodeRef3) {
            nodeRef5 = treeModel.getChild(nodeRef4, 1);
        }
        double d2 = treeModel.getNodeHeight(nodeRef4);
        double d3 = treeModel.getNodeHeight(nodeRef5);
        double d4 = Math.max(d3, treeModel.getNodeHeight(this.getOtherChild(treeModel, nodeRef3, nodeRef)));
        double d5 = treeModel.getNodeHeight(nodeRef);
        double d6 = Math.max(d5, treeModel.getNodeHeight(this.getOtherChild(treeModel, nodeRef3, nodeRef)));
        while ((d = MathUtils.nextDouble()) == 0.0 || d == 1.0) {
        }
        double d7 = d4 + d * (d2 - d4);
        treeModel.setNodeHeight(nodeRef3, d7);
        double d8 = Math.log((d2 - d4) / (d2 - d6));
        this.exchangeNodes(treeModel, nodeRef, nodeRef5, nodeRef3, nodeRef4);
        treeModel.pushTreeChangedEvent(nodeRef3);
        treeModel.pushTreeChangedEvent(nodeRef4);
        return d8;
    }

    @Override
    public String getOperatorName() {
        return "NearestNeighborInterchange";
    }

    public double getMinimumAcceptanceLevel() {
        return 0.025;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.05;
    }

    public String getPerformanceSuggestion() {
        return null;
    }
}

