/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.SampledMultivariateTraitLikelihood;
import dr.inference.distribution.GWishartLikelihood;
import dr.inference.distribution.MultivariateDistributionLikelihood;
import dr.inference.distribution.MultivariateNormalDistributionModel;
import dr.inference.distribution.WishartGammalDistributionModel;
import dr.inference.model.DiagonalConstrainedMatrixView;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.GWishartStatistics;
import dr.math.distributions.WishartDistribution;
import dr.math.distributions.WishartStatistics;
import dr.math.distributions.WishartSufficientStatistics;
import dr.math.interfaces.ConjugateWishartStatisticsProvider;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.Vector;
import dr.util.Attribute;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Arrays;
import java.util.List;

public class SparsePrecisionMatrixGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private static final String VARIANCE_OPERATOR = "sparsePrecisionGibbsOperator";
    public static final String TREE_MODEL = "treeModel";
    public static final String DISTRIBUTION = "distribution";
    public static final String PRIOR = "prior";
    private static final String WORKING = "workingDistribution";
    private final AbstractMultivariateTraitLikelihood traitModel;
    private AbstractMultivariateTraitLikelihood debugModel = null;
    private final ConjugateWishartStatisticsProvider conjugateWishartProvider;
    private final MultivariateDistributionLikelihood multivariateLikelihood;
    private final Parameter meanParam;
    private final MatrixParameterInterface precisionParam;
    private Statistics priorStatistics;
    private Statistics workingStatistics;
    private final GWishartStatistics priorGWishart;
    private boolean gWishartIsPrior = false;
    private Parameter priorAdjParameter;
    private double[][] priorAdjMatrix;
    private double priorDf;
    private SymmetricMatrix priorInverseScaleMatrix;
    private final MutableTreeModel treeModel;
    private final int dim;
    private double numberObservations;
    private final String traitName;
    private final boolean isSampledTraitLikelihood;
    private double pathWeight = 1.0;
    private boolean wishartIsModel = false;
    private WishartGammalDistributionModel priorModel = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(AbstractMultivariateTraitLikelihood.class, true), new ElementRule(ConjugateWishartStatisticsProvider.class, true), new ElementRule(MultivariateDistributionLikelihood.class, true), new ElementRule(GWishartLikelihood.class, true), new ElementRule(MatrixParameterInterface.class, true)};

        @Override
        public String getParserName() {
            return SparsePrecisionMatrixGibbsOperator.VARIANCE_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood = (AbstractMultivariateTraitLikelihood)xMLObject.getChild(AbstractMultivariateTraitLikelihood.class);
            ConjugateWishartStatisticsProvider conjugateWishartStatisticsProvider = (ConjugateWishartStatisticsProvider)xMLObject.getChild(ConjugateWishartStatisticsProvider.class);
            if (conjugateWishartStatisticsProvider == abstractMultivariateTraitLikelihood) {
                conjugateWishartStatisticsProvider = null;
            }
            GWishartLikelihood gWishartLikelihood = null;
            MatrixParameterInterface matrixParameterInterface = null;
            MultivariateDistributionLikelihood multivariateDistributionLikelihood = null;
            if (abstractMultivariateTraitLikelihood != null) {
                matrixParameterInterface = abstractMultivariateTraitLikelihood.getDiffusionModel().getPrecisionParameter();
                gWishartLikelihood = (GWishartLikelihood)xMLObject.getChild(GWishartLikelihood.class);
            }
            if (conjugateWishartStatisticsProvider != null) {
                matrixParameterInterface = conjugateWishartStatisticsProvider.getPrecisionParameter();
                gWishartLikelihood = (GWishartLikelihood)xMLObject.getChild(GWishartLikelihood.class);
            }
            if (!(gWishartLikelihood.getDistribution() instanceof WishartStatistics)) {
                throw new XMLParseException("Only a Wishart or GWishart distribution are conjugate for Gibbs sampling");
            }
            if (matrixParameterInterface.getColumnDimension() != matrixParameterInterface.getRowDimension()) {
                throw new XMLParseException("The variance matrix is not square or of wrong dimension");
            }
            if (abstractMultivariateTraitLikelihood != null && conjugateWishartStatisticsProvider == null) {
                if (matrixParameterInterface instanceof DiagonalConstrainedMatrixView && (matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class)) == null) {
                    throw new XMLParseException("Must provide unconstrained precision matrix");
                }
                if (gWishartLikelihood.getDistribution() instanceof GWishartStatistics) {
                    return new SparsePrecisionMatrixGibbsOperator(matrixParameterInterface, abstractMultivariateTraitLikelihood, gWishartLikelihood.getDistribution(), d);
                }
                return new SparsePrecisionMatrixGibbsOperator(matrixParameterInterface, abstractMultivariateTraitLikelihood, gWishartLikelihood.getDistribution(), d);
            }
            if (conjugateWishartStatisticsProvider != null) {
                if (matrixParameterInterface instanceof DiagonalConstrainedMatrixView) {
                    matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
                    if (matrixParameterInterface == null) {
                        throw new XMLParseException("Must provide unconstrained precision matrix");
                    }
                } else {
                    matrixParameterInterface = null;
                }
                WishartStatistics wishartStatistics = null;
                if (xMLObject.hasChildNamed(SparsePrecisionMatrixGibbsOperator.WORKING)) {
                    wishartStatistics = (WishartStatistics)xMLObject.getElementFirstChild(SparsePrecisionMatrixGibbsOperator.WORKING);
                }
                if (gWishartLikelihood.getDistribution() instanceof GWishartStatistics) {
                    return new SparsePrecisionMatrixGibbsOperator(conjugateWishartStatisticsProvider, matrixParameterInterface, gWishartLikelihood.getDistribution(), wishartStatistics, d, abstractMultivariateTraitLikelihood);
                }
                return new SparsePrecisionMatrixGibbsOperator(conjugateWishartStatisticsProvider, matrixParameterInterface, gWishartLikelihood.getDistribution(), wishartStatistics, d, abstractMultivariateTraitLikelihood);
            }
            return new SparsePrecisionMatrixGibbsOperator(multivariateDistributionLikelihood, gWishartLikelihood.getDistribution(), d);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a multivariate normal random walk operator on a given parameter.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private static final boolean DEBUG = false;

    public SparsePrecisionMatrixGibbsOperator(MultivariateDistributionLikelihood multivariateDistributionLikelihood, WishartStatistics wishartStatistics, double d) {
        System.out.println("-------------------------------------------------------------- SparsePrecisionMatrixGibbsOperator C1");
        this.traitModel = null;
        this.treeModel = null;
        this.traitName = null;
        this.conjugateWishartProvider = null;
        this.isSampledTraitLikelihood = false;
        this.priorGWishart = null;
        this.multivariateLikelihood = multivariateDistributionLikelihood;
        MultivariateNormalDistributionModel multivariateNormalDistributionModel = (MultivariateNormalDistributionModel)multivariateDistributionLikelihood.getDistribution();
        this.meanParam = multivariateNormalDistributionModel.getMeanParameter();
        this.precisionParam = multivariateNormalDistributionModel.getPrecisionMatrixParameter();
        this.dim = this.meanParam.getDimension();
        this.setupWishartStatistics(wishartStatistics);
        this.priorStatistics = this.setupStatistics(wishartStatistics);
        if (wishartStatistics instanceof WishartGammalDistributionModel) {
            this.wishartIsModel = true;
            this.priorModel = (WishartGammalDistributionModel)wishartStatistics;
        }
        this.setWeight(d);
    }

    private Statistics setupStatistics(WishartStatistics wishartStatistics) {
        double[][] dArray = wishartStatistics.getScaleMatrix();
        double[][] dArray2 = null;
        if (dArray != null) {
            dArray2 = new SymmetricMatrix(dArray).inverse().toComponents();
        }
        return new Statistics(wishartStatistics.getDF(), dArray2);
    }

    private Statistics setupStatistics(GWishartStatistics gWishartStatistics) {
        double[][] dArray = gWishartStatistics.getScaleMatrix();
        double[][] dArray2 = null;
        if (dArray != null) {
            dArray2 = new SymmetricMatrix(dArray).inverse().toComponents();
        }
        return new Statistics(gWishartStatistics.getDF(), dArray2, gWishartStatistics.getAdjMatrix());
    }

    private void setupWishartStatistics(WishartStatistics wishartStatistics) {
        this.priorDf = wishartStatistics.getDF();
        this.priorInverseScaleMatrix = null;
        double[][] dArray = wishartStatistics.getScaleMatrix();
        if (dArray != null) {
            this.priorInverseScaleMatrix = new SymmetricMatrix(dArray).inverse();
        }
    }

    private void setupGWishartStatistics(GWishartStatistics gWishartStatistics) {
        this.priorDf = gWishartStatistics.getDF();
        this.priorInverseScaleMatrix = null;
        double[][] dArray = gWishartStatistics.getScaleMatrix();
        if (dArray != null) {
            this.priorInverseScaleMatrix = new SymmetricMatrix(dArray).inverse();
        }
        this.priorAdjParameter = gWishartStatistics.getAdjParameter();
        this.priorAdjMatrix = gWishartStatistics.getAdjMatrix();
    }

    @Deprecated
    public SparsePrecisionMatrixGibbsOperator(MatrixParameterInterface matrixParameterInterface, AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood, WishartStatistics wishartStatistics, double d) {
        System.out.println("-------------------------------------------------------------- SparsePrecisionMatrixGibbsOperator C2");
        this.traitModel = abstractMultivariateTraitLikelihood;
        this.conjugateWishartProvider = null;
        this.meanParam = null;
        this.precisionParam = matrixParameterInterface;
        this.priorGWishart = null;
        this.setupWishartStatistics(wishartStatistics);
        this.priorStatistics = this.setupStatistics(wishartStatistics);
        if (wishartStatistics instanceof WishartGammalDistributionModel) {
            this.wishartIsModel = true;
            this.priorModel = (WishartGammalDistributionModel)wishartStatistics;
        }
        this.setWeight(d);
        this.treeModel = abstractMultivariateTraitLikelihood.getTreeModel();
        this.traitName = abstractMultivariateTraitLikelihood.getTraitName();
        this.dim = matrixParameterInterface.getRowDimension();
        this.isSampledTraitLikelihood = abstractMultivariateTraitLikelihood instanceof SampledMultivariateTraitLikelihood;
        if (!this.isSampledTraitLikelihood && !(abstractMultivariateTraitLikelihood instanceof ConjugateWishartStatisticsProvider)) {
            throw new RuntimeException("Only implemented for a SampledMultivariateTraitLikelihood or ConjugateWishartStatisticsProvider");
        }
        this.multivariateLikelihood = null;
    }

    @Deprecated
    public SparsePrecisionMatrixGibbsOperator(MatrixParameterInterface matrixParameterInterface, AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood, GWishartStatistics gWishartStatistics, double d) {
        System.out.println("-------------------------------------------------------------- SparsePrecisionMatrixGibbsOperator C3");
        this.traitModel = abstractMultivariateTraitLikelihood;
        this.conjugateWishartProvider = null;
        this.meanParam = null;
        this.precisionParam = matrixParameterInterface;
        this.priorGWishart = gWishartStatistics;
        this.gWishartIsPrior = true;
        this.setupGWishartStatistics(gWishartStatistics);
        this.priorStatistics = this.setupStatistics(gWishartStatistics);
        if (gWishartStatistics instanceof WishartGammalDistributionModel) {
            this.wishartIsModel = true;
            this.priorModel = (WishartGammalDistributionModel)((Object)gWishartStatistics);
        }
        this.setWeight(d);
        this.treeModel = abstractMultivariateTraitLikelihood.getTreeModel();
        this.traitName = abstractMultivariateTraitLikelihood.getTraitName();
        this.dim = matrixParameterInterface.getRowDimension();
        this.isSampledTraitLikelihood = abstractMultivariateTraitLikelihood instanceof SampledMultivariateTraitLikelihood;
        System.out.println("trait models inst of SampledMultivariateTraitLikelihood=" + (abstractMultivariateTraitLikelihood instanceof SampledMultivariateTraitLikelihood));
        System.out.println("trait models inst of ConjugateWishartStatisticsProvider=" + (abstractMultivariateTraitLikelihood instanceof ConjugateWishartStatisticsProvider));
        if (!this.isSampledTraitLikelihood && !(abstractMultivariateTraitLikelihood instanceof ConjugateWishartStatisticsProvider)) {
            throw new RuntimeException("Only implemented for a SampledMultivariateTraitLikelihood or ConjugateWishartStatisticsProvider");
        }
        this.multivariateLikelihood = null;
    }

    public SparsePrecisionMatrixGibbsOperator(ConjugateWishartStatisticsProvider conjugateWishartStatisticsProvider, MatrixParameterInterface matrixParameterInterface, WishartStatistics wishartStatistics, WishartStatistics wishartStatistics2, double d, AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood) {
        System.out.println("-------------------------------------------------------------- SparsePrecisionMatrixGibbsOperator C4");
        this.traitModel = null;
        this.debugModel = abstractMultivariateTraitLikelihood;
        this.conjugateWishartProvider = conjugateWishartStatisticsProvider;
        this.meanParam = null;
        this.precisionParam = matrixParameterInterface != null ? matrixParameterInterface : this.conjugateWishartProvider.getPrecisionParameter();
        this.isSampledTraitLikelihood = false;
        this.treeModel = null;
        this.traitName = null;
        this.priorGWishart = null;
        this.setupWishartStatistics(wishartStatistics);
        this.priorStatistics = this.setupStatistics(wishartStatistics);
        if (wishartStatistics instanceof WishartGammalDistributionModel) {
            this.wishartIsModel = true;
            this.priorModel = (WishartGammalDistributionModel)wishartStatistics;
        }
        if (wishartStatistics2 != null) {
            this.workingStatistics = this.setupStatistics(wishartStatistics2);
        }
        this.setWeight(d);
        this.dim = this.precisionParam.getRowDimension();
        this.multivariateLikelihood = null;
    }

    public SparsePrecisionMatrixGibbsOperator(ConjugateWishartStatisticsProvider conjugateWishartStatisticsProvider, MatrixParameterInterface matrixParameterInterface, GWishartStatistics gWishartStatistics, WishartStatistics wishartStatistics, double d, AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood) {
        System.out.println("-------------------------------------------------------------- SparsePrecisionMatrixGibbsOperator C5");
        this.traitModel = null;
        this.debugModel = abstractMultivariateTraitLikelihood;
        this.conjugateWishartProvider = conjugateWishartStatisticsProvider;
        this.meanParam = null;
        this.precisionParam = matrixParameterInterface != null ? matrixParameterInterface : this.conjugateWishartProvider.getPrecisionParameter();
        this.isSampledTraitLikelihood = false;
        this.treeModel = null;
        this.traitName = null;
        this.priorGWishart = gWishartStatistics;
        this.gWishartIsPrior = true;
        this.setupGWishartStatistics(gWishartStatistics);
        this.priorStatistics = this.setupStatistics(gWishartStatistics);
        if (gWishartStatistics instanceof WishartGammalDistributionModel) {
            this.wishartIsModel = true;
            this.priorModel = (WishartGammalDistributionModel)((Object)gWishartStatistics);
        }
        if (wishartStatistics != null) {
            this.workingStatistics = this.setupStatistics(wishartStatistics);
        }
        this.setWeight(d);
        this.dim = this.precisionParam.getRowDimension();
        this.multivariateLikelihood = null;
    }

    @Override
    public void setPathParameter(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Illegal path weight of " + d);
        }
        this.pathWeight = d;
    }

    public int getStepCount() {
        return 1;
    }

    private void incrementOuterProduct(double[][] dArray, MultivariateDistributionLikelihood multivariateDistributionLikelihood) {
        System.out.println("incrementOuterProduct MultivariateDistributionLikelihood");
        double[] dArray2 = multivariateDistributionLikelihood.getDistribution().getMean();
        this.numberObservations = 0.0;
        List<Attribute<double[]>> list = multivariateDistributionLikelihood.getDataList();
        for (Attribute<double[]> attribute : list) {
            int n;
            double[] dArray3 = attribute.getAttributeValue();
            for (n = 0; n < this.dim; ++n) {
                int n2 = n;
                dArray3[n2] = dArray3[n2] - dArray2[n];
            }
            for (n = 0; n < this.dim; ++n) {
                for (int i = n; i < this.dim; ++i) {
                    double[] dArray4 = dArray[n];
                    int n3 = i;
                    double d = dArray4[n3] + dArray3[n] * dArray3[i];
                    dArray4[n3] = d;
                    dArray[i][n] = d;
                }
            }
            this.numberObservations += 1.0;
        }
    }

    private void incrementOuterProduct(double[][] dArray, ConjugateWishartStatisticsProvider conjugateWishartStatisticsProvider) {
        System.out.println("incrementOuterProduct ConjugateWishartStatisticsProvider");
        WishartSufficientStatistics wishartSufficientStatistics = conjugateWishartStatisticsProvider.getWishartStatistics();
        double[] dArray2 = wishartSufficientStatistics.getScaleMatrix();
        double d = wishartSufficientStatistics.getDf();
        if (this.debugModel != null) {
            WishartSufficientStatistics wishartSufficientStatistics2 = ((ConjugateWishartStatisticsProvider)((Object)this.debugModel)).getWishartStatistics();
            System.err.println(d + " ?= " + wishartSufficientStatistics2.getDf());
            System.err.println(new Vector(dArray2));
            System.err.println("");
            System.err.println(new Vector(wishartSufficientStatistics2.getScaleMatrix()));
            System.exit(-1);
        }
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(dArray2, i * n, dArray[i], 0, n);
        }
        this.numberObservations = d;
    }

    private void incrementOuterProduct(double[][] dArray, NodeRef nodeRef) {
        System.out.println("incrementOuterProduct NodeRef");
        if (!this.treeModel.isRoot(nodeRef)) {
            NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
            double[] dArray2 = this.treeModel.getMultivariateNodeTrait(nodeRef2, this.traitName);
            double[] dArray3 = this.treeModel.getMultivariateNodeTrait(nodeRef, this.traitName);
            double d = this.traitModel.getRescaledBranchLengthForPrecision(nodeRef);
            if (d > 0.0) {
                int n;
                double d2 = Math.sqrt(d);
                double[] dArray4 = new double[this.dim];
                for (n = 0; n < this.dim; ++n) {
                    dArray4[n] = (dArray3[n] - dArray2[n]) / d2;
                }
                for (n = 0; n < this.dim; ++n) {
                    for (int i = n; i < this.dim; ++i) {
                        double[] dArray5 = dArray[n];
                        int n2 = i;
                        double d3 = dArray5[n2] + dArray4[n] * dArray4[i];
                        dArray5[n2] = d3;
                        dArray[i][n] = d3;
                    }
                }
                this.numberObservations += 1.0;
            }
        }
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            this.incrementOuterProduct(dArray, this.treeModel.getChild(nodeRef, i));
        }
    }

    private double[][] getOperationScaleMatrixAndSetObservationCount() {
        double[][] dArray = new double[this.dim][this.dim];
        Matrix matrix = null;
        this.numberObservations = 0.0;
        if (this.isSampledTraitLikelihood) {
            this.incrementOuterProduct(dArray, this.treeModel.getRoot());
        } else if (this.traitModel != null) {
            this.incrementOuterProduct(dArray, (ConjugateWishartStatisticsProvider)((Object)this.traitModel));
        } else if (this.conjugateWishartProvider != null) {
            this.incrementOuterProduct(dArray, this.conjugateWishartProvider);
        } else {
            this.incrementOuterProduct(dArray, this.multivariateLikelihood);
        }
        try {
            SymmetricMatrix symmetricMatrix = new SymmetricMatrix(dArray);
            if (this.pathWeight != 1.0) {
                symmetricMatrix = (SymmetricMatrix)symmetricMatrix.product(this.pathWeight);
            }
            if (this.priorInverseScaleMatrix != null) {
                symmetricMatrix = this.priorInverseScaleMatrix.add(symmetricMatrix);
            }
            matrix = symmetricMatrix.inverse();
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        assert (matrix != null);
        return matrix.toComponents();
    }

    @Override
    public double doOperation() {
        this.doOperationDontFireChange();
        this.precisionParam.fireParameterChangedEvent();
        return 0.0;
    }

    public void flipOne(int n, Parameter parameter) {
        parameter.setParameterValue(n, 0.0);
    }

    public void flipZero(int n, Parameter parameter) {
        parameter.setParameterValue(n, 1.0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doOperationDontFireChange() {
        int n;
        Parameter parameter;
        int n2;
        if (this.wishartIsModel) {
            this.setupWishartStatistics(this.priorModel);
            this.priorStatistics = this.setupStatistics(this.priorModel);
        }
        double[][] dArray = this.getOperationScaleMatrixAndSetObservationCount();
        double d = this.numberObservations;
        double d2 = this.priorDf + d * this.pathWeight;
        double[][] dArray2 = null;
        if (this.gWishartIsPrior) {
            n2 = MathUtils.nextInt(this.dim * (this.dim - 1) / 2);
            parameter = new Parameter.Default(this.priorAdjParameter.getParameterValues());
            n = (int)parameter.getParameterValue(n2);
            System.out.println("\nGc0=" + Arrays.toString(this.priorAdjParameter.getParameterValues()));
            System.out.println("Gp0=" + Arrays.toString(parameter.getParameterValues()));
            if (n == 0) {
                this.flipZero(n2, parameter);
            } else {
                if (n != 1) throw new RuntimeException("expected 1 or 0");
                this.flipOne(n2, parameter);
            }
            System.out.println("Gp1=" + Arrays.toString(parameter.getParameterValues()));
            System.out.println("priorscaleMatrix=" + Arrays.deepToString((Object[])this.priorGWishart.getScaleMatrix()));
            System.out.println("     scaleMatrix=" + Arrays.deepToString((Object[])dArray));
            double d3 = GWishartLikelihood.computeNormalizationConstant(this.priorDf, this.priorGWishart.getScaleMatrix(), this.priorAdjParameter, this.dim);
            double d4 = GWishartLikelihood.computeNormalizationConstant(d2, dArray, this.priorAdjParameter, this.dim);
            double d5 = GWishartLikelihood.computeNormalizationConstant(this.priorDf, this.priorGWishart.getScaleMatrix(), parameter, this.dim);
            double d6 = GWishartLikelihood.computeNormalizationConstant(d2, dArray, parameter, this.dim);
            System.out.println("IGcPrior=" + d3);
            System.out.println("IGcPosterior=" + d4);
            System.out.println("IGpPrior=" + d5);
            System.out.println("IGpPosterior=" + d6);
            double d7 = 0.0;
            d7 = Double.isInfinite(d3) || Double.isInfinite(d4) || Double.isInfinite(d5) || Double.isInfinite(d6) ? 0.0 : Math.exp(-(d6 - d5) + (d4 - d3));
            double d8 = MathUtils.nextDouble();
            if (d8 < d7 && !Double.isNaN(d7)) {
                System.out.println("U=" + d8 + " < alpha=" + d7 + "--------------------------------------------------------------- ACCEPT NEW GRAPH");
                n = (int)this.priorAdjParameter.getParameterValue(n2);
                if (n == 0) {
                    this.flipZero(n2, this.priorAdjParameter);
                } else {
                    if (n != 1) throw new RuntimeException("expected 1 or 0");
                    this.flipOne(n2, this.priorAdjParameter);
                }
            } else {
                System.out.println("U=" + d8 + " >= alpha=" + d7 + "------------------------------------------- REJECT NEW GRAPH");
                n = (int)parameter.getParameterValue(n2);
                if (n == 0) {
                    this.flipZero(n2, parameter);
                } else {
                    if (n != 1) throw new RuntimeException("expected 1 or 0");
                    this.flipOne(n2, parameter);
                }
            }
            System.out.println("Gc1=" + Arrays.toString(this.priorAdjParameter.getParameterValues()));
            System.out.println("Gp2=" + Arrays.toString(parameter.getParameterValues()));
            dArray2 = GWishartLikelihood.nextGWishart(d2, dArray, this.priorGWishart.getAdjMatrix());
        } else {
            dArray2 = WishartDistribution.nextWishart(d2, dArray);
        }
        for (n2 = 0; n2 < this.dim; ++n2) {
            parameter = this.precisionParam.getParameter(n2);
            for (n = 0; n < this.dim; ++n) {
                parameter.setParameterValueQuietly(n, dArray2[n][n2]);
            }
        }
    }

    public MatrixParameterInterface getPrecisionParam() {
        return this.precisionParam;
    }

    public ConjugateWishartStatisticsProvider getConjugateWishartProvider() {
        return this.conjugateWishartProvider;
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    @Override
    public String getOperatorName() {
        return VARIANCE_OPERATOR;
    }

    private class Statistics {
        final double degreesOfFreedom;
        final double[][] rateMatrix;
        final double[][] adjMatrix;

        Statistics(double d, double[][] dArray) {
            this.degreesOfFreedom = d;
            this.rateMatrix = dArray;
            this.adjMatrix = null;
        }

        Statistics(double d, double[][] dArray, double[][] dArray2) {
            this.degreesOfFreedom = d;
            this.rateMatrix = dArray;
            this.adjMatrix = dArray2;
        }
    }
}

