/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Parameter;
import java.util.List;

public class SubstitutionRateMatrixMixture
extends DesignMatrix {
    public SubstitutionRateMatrixMixture(List<SubstitutionModel> list) {
        super(SubstitutionRateMatrixMixture.getName(list), SubstitutionRateMatrixMixture.getParameters(list), false);
        if (!this.modelsAreSameSize(list)) {
            throw new RuntimeException("SubstitutionRateMatrixMixture requires all component models have same dimension.");
        }
    }

    private static String getName(List<SubstitutionModel> list) {
        StringBuilder stringBuilder = new StringBuilder("designMatrix");
        for (SubstitutionModel substitutionModel : list) {
            String string = substitutionModel.getId();
            if (string == null || string.length() <= 0) continue;
            stringBuilder.append(".").append(string);
        }
        return stringBuilder.toString();
    }

    private static Parameter[] getParameters(List<SubstitutionModel> list) {
        Parameter[] parameterArray = new Parameter[list.size()];
        int n = list.get(0).getFrequencyModel().getFrequencyCount();
        int n2 = n * n;
        int n3 = n * (n - 1);
        int n4 = n3 / 2;
        for (int i = 0; i < parameterArray.length; ++i) {
            SubstitutionModel substitutionModel = list.get(i);
            double[] dArray = new double[n2];
            substitutionModel.getInfinitesimalMatrix(dArray);
            double[] dArray2 = substitutionModel.getFrequencyModel().getFrequencies();
            for (int j = 0; j < n; ++j) {
                dArray2[j] = Math.log(dArray2[j]);
            }
            double[] dArray3 = new double[n3];
            int n5 = 0;
            for (int j = 0; j < n - 1; ++j) {
                for (int k = j + 1; k < n; ++k) {
                    dArray3[n5] = Math.log(dArray[j * n + k]) - dArray2[k];
                    dArray3[n5 + n4] = Math.log(dArray[k * n + j]) - dArray2[j];
                    ++n5;
                }
            }
            parameterArray[i] = new Parameter.Default(dArray3);
        }
        return parameterArray;
    }

    private boolean modelsAreSameSize(List<SubstitutionModel> list) {
        boolean bl = true;
        int n = list.get(0).getFrequencyModel().getFrequencyCount();
        for (int i = 0; i < list.size(); ++i) {
            int n2 = list.get(i).getFrequencyModel().getFrequencyCount();
            if (n2 == n) continue;
            bl = false;
        }
        return bl;
    }
}

