/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.evomodel.bigfasttree.BigFastTreeIntervals;
import dr.evomodel.tree.TreeModel;
import dr.inference.distribution.RandomField;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;

public class Weights
extends AbstractModel
implements RandomField.WeightProvider {
    private final TreeModel tree;
    private BigFastTreeIntervals intervals;
    private boolean indicesKnown;
    private int[] indices;

    public Weights(TreeModel treeModel) {
        super("just work");
        this.tree = treeModel;
        this.intervals = new BigFastTreeIntervals(treeModel);
        this.addModel(this.intervals);
        this.indicesKnown = false;
    }

    @Override
    public double weight(int n, int n2) {
        if (!this.indicesKnown) {
            this.indices = this.getIndex();
            this.indicesKnown = true;
        }
        if (Math.abs(n - n2) != 1) {
            return 0.0;
        }
        if ((n2 = this.indices[n2]) < (n = this.indices[n])) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        return 2.0 / (this.intervals.getInterval(n) + this.intervals.getInterval(n2));
    }

    @Override
    public int getDimension() {
        int n = 0;
        for (int i = 1; i < this.intervals.getIntervalCount(); ++i) {
            if (this.intervals.getIntervalTime(i) == this.intervals.getIntervalTime(i - 1)) continue;
            ++n;
        }
        return n;
    }

    private int[] getIndex() {
        int n = this.getDimension();
        int[] nArray = new int[n + 1];
        int n2 = 0;
        for (int i = 1; i < this.intervals.getIntervalCount(); ++i) {
            if (this.intervals.getIntervalTime(i) == this.intervals.getIntervalTime(i - 1)) continue;
            nArray[n2] = i - 1;
            ++n2;
        }
        nArray[n] = this.intervals.getIntervalCount() - 1;
        return nArray;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model != this.intervals) {
            throw new IllegalArgumentException("Unknown model");
        }
        this.indicesKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.indicesKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public boolean isUsed() {
        return false;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void setId(String string) {
    }
}

