/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions.gp;

import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.List;

public interface GaussianProcessKernel {
    public double getUnscaledCovariance(double var1, double var3);

    public double getUnscaledCovariance(double[] var1, double[] var2);

    public double getScale();

    public static GaussianProcessKernel factory(String string, String string2, List<Parameter> list) throws IllegalArgumentException {
        for (AllKernels allKernels : AllKernels.values()) {
            if (!string.equalsIgnoreCase(allKernels.toString())) continue;
            return allKernels.factory(string2, list);
        }
        throw new IllegalArgumentException("Unknown kernel type");
    }

    public static enum AllKernels {
        LINEAR("DotProduct"){

            @Override
            GaussianProcessKernel factory(String string, List<Parameter> list) {
                return new Linear(string, list);
            }
        }
        ,
        OU("OrnsteinUhlenbeck"){

            @Override
            GaussianProcessKernel factory(String string, List<Parameter> list) {
                return new OrnsteinUhlenbeck(string, list);
            }
        }
        ,
        SE("SquaredExponential"){

            @Override
            GaussianProcessKernel factory(String string, List<Parameter> list) {
                return new SquaredExponential(string, list);
            }
        }
        ,
        MATERN32("Matern3/2"){

            @Override
            GaussianProcessKernel factory(String string, List<Parameter> list) {
                return new MaternThreeHalves(string, list);
            }
        }
        ,
        MATERN52("Matern5/2"){

            @Override
            GaussianProcessKernel factory(String string, List<Parameter> list) {
                return new MaternFiveHalves(string, list);
            }
        };

        private final String name;

        private AllKernels(String string2) {
            this.name = string2;
        }

        abstract GaussianProcessKernel factory(String var1, List<Parameter> var2);

        public String toString() {
            return this.name;
        }
    }

    public static abstract class Base
    extends AbstractModel
    implements GaussianProcessKernel {
        final List<Parameter> parameters;

        public Base(String string, List<Parameter> list) {
            super(string);
            this.parameters = list;
            for (Parameter parameter : list) {
                this.addVariable(parameter);
            }
        }

        double normSquared(double[] dArray, double[] dArray2) {
            int n = dArray.length;
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                double d2 = dArray[i] - dArray2[i];
                d += d2 * d2;
            }
            return d;
        }

        @Override
        public double getScale() {
            return this.parameters.get(0).getParameterValue(0);
        }

        double getLength() {
            return this.parameters.get(1).getParameterValue(0);
        }

        @Override
        protected void handleModelChangedEvent(Model model, Object object, int n) {
        }

        @Override
        protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
            if (!this.parameters.contains((Parameter)variable)) {
                throw new IllegalArgumentException("Unknown variable");
            }
            this.fireModelChanged(variable, n);
        }

        @Override
        protected void storeState() {
        }

        @Override
        protected void restoreState() {
        }

        @Override
        protected void acceptState() {
        }
    }

    public static abstract class NormedBase
    extends Base {
        public NormedBase(String string, List<Parameter> list) {
            super(string, list);
        }

        abstract double functionalForm(double var1);

        @Override
        public double getUnscaledCovariance(double d, double d2) {
            double d3 = Math.abs(d - d2);
            return this.functionalForm(d3);
        }

        @Override
        public double getUnscaledCovariance(double[] dArray, double[] dArray2) {
            double d = Math.sqrt(this.normSquared(dArray, dArray2));
            return this.functionalForm(d);
        }
    }

    public static class MaternThreeHalves
    extends NormedBase {
        private static final String TYPE = "Matern3/2";

        public MaternThreeHalves(String string, List<Parameter> list) {
            super(string, list);
        }

        @Override
        double functionalForm(double d) {
            double d2 = this.getLength();
            double d3 = Math.sqrt(3.0) * d / d2;
            return (1.0 + d3) * Math.exp(-d3);
        }
    }

    public static class MaternFiveHalves
    extends NormedBase {
        private static final String TYPE = "Matern5/2";

        public MaternFiveHalves(String string, List<Parameter> list) {
            super(string, list);
        }

        @Override
        double functionalForm(double d) {
            double d2 = this.getLength();
            double d3 = Math.sqrt(5.0) * d / d2;
            double d4 = 5.0 * d * d / (3.0 * d2 * d2);
            return (1.0 + d3 + d4) * Math.exp(-d3);
        }
    }

    public static class OrnsteinUhlenbeck
    extends NormedBase {
        private static final String TYPE = "OrnsteinUhlenbeck";

        public OrnsteinUhlenbeck(String string, List<Parameter> list) {
            super(string, list);
        }

        @Override
        double functionalForm(double d) {
            double d2 = this.getLength();
            return Math.exp(-d / d2);
        }
    }

    public static class SquaredExponential
    extends Base {
        private static final String TYPE = "SquaredExponential";

        public SquaredExponential(String string, List<Parameter> list) {
            super(string, list);
        }

        private double functionalForm(double d) {
            double d2 = this.getLength();
            return Math.exp(-d / (2.0 * d2 * d2));
        }

        @Override
        public double getUnscaledCovariance(double d, double d2) {
            double d3 = d - d2;
            return this.functionalForm(d3 * d3);
        }

        @Override
        public double getUnscaledCovariance(double[] dArray, double[] dArray2) {
            return this.functionalForm(this.normSquared(dArray, dArray2));
        }
    }

    public static class Linear
    extends Base {
        private static final String TYPE = "DotProduct";

        public Linear(String string, List<Parameter> list) {
            super(string, list);
        }

        @Override
        public double getUnscaledCovariance(double d, double d2) {
            return d * d2;
        }

        @Override
        public double getUnscaledCovariance(double[] dArray, double[] dArray2) {
            int n = dArray.length;
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                d += dArray[i] * dArray2[i];
            }
            return d;
        }
    }
}

