/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TridiagMatrix
extends AbstractMatrix {
    double[] diag;
    double[] superDiag;
    double[] subDiag;
    private int n;

    public TridiagMatrix(int n) {
        super(n, n);
        if (n < 1) {
            throw new IllegalArgumentException("n must be >= 1");
        }
        this.n = n;
        this.diag = new double[n];
        this.superDiag = new double[n - 1];
        this.subDiag = new double[n - 1];
    }

    public TridiagMatrix(Matrix A) {
        this(A, true);
    }

    public TridiagMatrix(Matrix A, boolean deep) {
        super(A);
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Tridiagonal matrix must be square");
        }
        if (A.numRows() < 1) {
            throw new IllegalArgumentException("numRows must be >= 1");
        }
        this.n = this.numRows;
        if (deep) {
            this.diag = new double[this.n];
            this.superDiag = new double[this.n - 1];
            this.subDiag = new double[this.n - 1];
            for (MatrixEntry e : A) {
                if (e.row() != e.column() && e.row() != e.column() - 1 && e.row() != e.column() + 1) continue;
                this.set(e.row(), e.column(), e.get());
            }
        } else {
            TridiagMatrix B = (TridiagMatrix)A;
            this.diag = B.getDiagonal();
            this.subDiag = B.getSubDiagonal();
            this.superDiag = B.getSuperDiagonal();
        }
    }

    public double[] getDiagonal() {
        return this.diag;
    }

    public double[] getSubDiagonal() {
        return this.subDiag;
    }

    public double[] getSuperDiagonal() {
        return this.superDiag;
    }

    @Override
    public void add(int row, int column, double value) {
        this.check(row, column);
        if (row == column) {
            int n = row;
            this.diag[n] = this.diag[n] + value;
        } else if (row == column + 1) {
            int n = column;
            this.subDiag[n] = this.subDiag[n] + value;
        } else if (row == column - 1) {
            int n = row;
            this.superDiag[n] = this.superDiag[n] + value;
        } else {
            throw new IndexOutOfBoundsException("Insertion index outside of band");
        }
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        if (row == column) {
            return this.diag[row];
        }
        if (row == column + 1) {
            return this.subDiag[column];
        }
        if (row == column - 1) {
            return this.superDiag[row];
        }
        return 0.0;
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        if (row == column) {
            this.diag[row] = value;
        } else if (row == column + 1) {
            this.subDiag[column] = value;
        } else if (row == column - 1) {
            this.superDiag[row] = value;
        } else {
            throw new IndexOutOfBoundsException("Insertion index outside of band");
        }
    }

    @Override
    public TridiagMatrix copy() {
        return new TridiagMatrix(this);
    }

    @Override
    public TridiagMatrix zero() {
        Arrays.fill(this.diag, 0.0);
        Arrays.fill(this.subDiag, 0.0);
        Arrays.fill(this.superDiag, 0.0);
        return this;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        int info = Interface.lapack().gtsv(this.numRows, X.numColumns(), (double[])this.subDiag.clone(), (double[])this.diag.clone(), (double[])this.superDiag.clone(), Xd);
        if (info > 0) {
            throw new MatrixSingularException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    @Override
    public Matrix transpose() {
        double[] otherDiag = this.subDiag;
        this.subDiag = this.superDiag;
        this.superDiag = otherDiag;
        return this;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new TridiagMatrixIterator();
    }

    private class TridiagMatrixIterator
    extends AbstractMatrix.RefMatrixIterator {
        private double[] band;
        private int bandIndex;
        private int whichBand;

        private TridiagMatrixIterator() {
            this.band = TridiagMatrix.this.diag;
        }

        public boolean hasNext() {
            return this.whichBand < 3;
        }

        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (this.bandIndex < this.band.length - 1) {
                ++this.bandIndex;
            } else {
                this.bandIndex = 0;
                ++this.whichBand;
                if (this.whichBand == 1) {
                    this.band = TridiagMatrix.this.subDiag;
                } else if (this.whichBand == 2) {
                    this.band = TridiagMatrix.this.superDiag;
                }
                if (this.band.length == 0) {
                    this.whichBand = 3;
                }
            }
            this.row = this.whichBand == 1 ? this.bandIndex + 1 : this.bandIndex;
            this.column = this.whichBand == 2 ? this.bandIndex + 1 : this.bandIndex;
            return this.entry;
        }
    }
}

