% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_powerP.R
\name{evidence_powerP}
\alias{evidence_powerP}
\title{Marginal likelihood estimation}
\usage{
evidence_powerP(ergm.formula, prior.mean, prior.sigma, nits, burnin, thin = 1,
  tunePL = 2, seed = 1, temps = seq(0, 1, length.out = 50)^5, calibr.info)
}
\arguments{
\item{ergm.formula}{formula; an \code{R} formula object,
of the form  <network> ~ <model terms>
where <network> is a \code{\link{network}} object
and <model terms> are \code{\link{ergm-terms}}.}

\item{prior.mean}{vector; Prior means.}

\item{prior.sigma}{matrix; Prior covariance matrix.}

\item{nits}{count; Number of MCMC iterations after burn-in for the adjusted pseudo-posterior estimation.}

\item{burnin}{count; Number of burn-in iterations at the beginning of an MCMC run for the adjusted pseudo-posterior estimation.}

\item{thin}{count; Thinning interval used in the simulation for the adjusted pseudo-posterior estimation. The number of MCMC iterations must be divisible by this value.}

\item{tunePL}{count; Tuning parameter for the Metropolis sampling for the pseudo-posterior estimation.}

\item{seed}{The seed for the random number generator. See \code{\link[MCMCpack]{MCMCmetrop1R}}.}

\item{temps}{numeric vector; Inverse temperature ladder, \eqn{t\in[0,1]}.}

\item{calibr.info}{list; Transformation parameters for
adjusting the pseudolikelihood function. See \code{\link[Bergm]{adjustPL}}.}
}
\description{
Function to estimate the marginal likelihood with Power posteriors, 
based on the adjusted pseudolikelihood function.
}
\examples{
\dontrun{
# Load the florentine marriage network:
data(florentine)

flo.formula <- flomarriage ~ edges + kstar(2)

info.adjustPL <- adjustPL(ergm.formula = flo.formula,
                          aux.iters    = 100, 
                          noisy.nsim   = 50,   
                          noisy.thin   = 50,   
                          ladder       = 30,   
                          estimate     = "MLE",
                          control      = control.ergm(MCMC.samplesize=2000))

# Add the output into a list:
calibration.list <- list(Theta_MLE= info.adjustPL$Theta_MLE,
                         Theta_PL = info.adjustPL$Theta_PL, 
                         W        = info.adjustPL$W, 
                         C        = info.adjustPL$C)
                         
# Specify location and shape of prior distribution: 
mean.priors  <- rep(0,2)
sigma        <- 5
sigma.priors <- diag(sigma,2)   
                                                
# MCMC sampling and evidence estimation:

tempvec.powerp  <- seq(0,1,length.out=20)^5

pp.est.evidence <- evidence_powerP(ergm.formula = flo.formula,
                                   prior.mean   = mean.priors,   
                                   prior.sigma  = sigma.priors,
                                   nits         = 10000,
                                   burnin       = 2000,
                                   thin         = 1,
                                   tunePL       = 2,
                                   seed         = 1,
                                   temps        = tempvec.powerp,
                                   calibr.info  = calibration.list)
                                   
# MCMC diagnostics and posterior summaries:
bergm.output(pp.est.evidence)
  
# Log-marginal likelihood estimate:             
flo.model.logevidence <- pp.est.evidence$log.evidence
}

}
\references{
Bouranis, L., Friel, N., and Maire, F. (2017). Bayesian model selection for exponential random graph models via
adjusted pseudolikelihoods. \url{https://arxiv.org/abs/1706.06344}
}
