% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bergmC.R
\name{bergmC}
\alias{bergmC}
\title{Calibrating misspecified Bayesian ERGMs}
\usage{
bergmC(
  formula,
  prior.mean = NULL,
  prior.sigma = NULL,
  burn.in = 10000,
  main.iters = 40000,
  aux.iters = 3000,
  V.proposal = 1.5,
  thin = 1,
  rm.iters = 500,
  rm.a = 0.001,
  rm.alpha = 0,
  n.aux.draws = 400,
  aux.thin = 50,
  estimate = c("MLE", "CD"),
  seed = 1,
  ...
)
}
\arguments{
\item{formula}{formula; an \code{\link[ergm]{ergm}} formula object,
of the form  <network> ~ <model terms>
where <network> is a \code{\link[network]{network}} object
and <model terms> are \code{ergm-terms}.}

\item{prior.mean}{vector; mean vector of the multivariate Normal prior.
By default set to a vector of 0's.}

\item{prior.sigma}{square matrix; variance/covariance matrix for the multivariate Normal prior.
By default set to a diagonal matrix with every diagonal entry equal to 100.}

\item{burn.in}{count; number of burn-in iterations at the beginning of an MCMC run for the pseudo-posterior estimation.}

\item{main.iters}{count; number of MCMC iterations after burn-in for the pseudo-posterior estimation.}

\item{aux.iters}{count; number of auxiliary iterations used for drawing the first network from the ERGM likelihood (Robbins-Monro). See \code{\link[ergm]{control.simulate.formula}}.}

\item{V.proposal}{count; diagonal entry for the multivariate Normal proposal.
By default set to 1.5.}

\item{thin}{count; thinning interval used in the simulation for the pseudo-posterior estimation. The number of MCMC iterations must be divisible by this value.}

\item{rm.iters}{count; number of iterations for the Robbins-Monro stochastic approximation algorithm.}

\item{rm.a}{scalar; constant for sequence alpha_n (Robbins-Monro).}

\item{rm.alpha}{scalar; noise added to gradient (Robbins-Monro).}

\item{n.aux.draws}{count; number of auxiliary networks drawn from the ERGM likelihood (Robbins-Monro). See \code{\link[ergm]{control.simulate.formula}}.}

\item{aux.thin}{count; number of auxiliary iterations between network draws after the first network is drawn (Robbins-Monro). See \code{\link[ergm]{control.simulate.formula}}.}

\item{estimate}{If "MLE" (the default), then an approximate maximum likelihood estimator is used as a starting point in the Robbins-Monro algorithm. If "CD" , the Monte-Carlo contrastive divergence estimate is returned. See \code{\link[ergm]{ergm}}.}

\item{seed}{integer; seed for the random number generator. See \code{set.seed}.}

\item{...}{Additional arguments, to be passed to the ergm function. See \code{\link[ergm]{ergm}}.}
}
\description{
Function to transform a sample from the pseudo-posterior 
to one that is approximately sampled from the intractable 
posterior distribution.
}
\examples{
\dontrun{
# Load the florentine marriage network
data(florentine)
                                 
# Calibrated pseudo-posterior:
cpp.flo <- bergmC(flomarriage ~ edges + kstar(2),
                  aux.iters  = 500,
                  burn.in    = 500,
                  main.iters = 10000,
                  V.proposal = 2.5)

# Posterior summaries:
summary(cpp.flo)
}

}
\references{
Bouranis, L., Friel, N., & Maire, F. (2017). Efficient Bayesian inference for exponential 
random graph models by correcting the pseudo-posterior distribution. 
Social Networks, 50, 98-108. \url{https://arxiv.org/abs/1510.00934}
}
