% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sample_posterior_v}
\alias{sample_posterior_v}
\title{Generate samples from the posterior under the variant-level pathogenicity model}
\usage{
sample_posterior_v(y, G, min_ac = 1L, q_shape = c(2, 100), p_shape = c(10,
  2), omega_shape = c(2, 9), variant_weights = NULL,
  estimate_phi = !is.null(variant_weights), samples = 10000,
  burn = as.integer(samples/10), just_Z = FALSE)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one column per individual and one row per variant.}

\item{min_ac}{Minimum allele count per individual to be considered to have a pathogenic combination of variants. '1' could correspond to a dominant inheritance hypothesis whereas '2' could correspond to a recessive inheritance hypothesis.}

\item{q_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with non-pathogenic variant combinations (i.e. they have less than \code{min_ac} variants.}

\item{p_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with pathogenic variant combinations (i.e. they have at least \code{min_ac} variants.}

\item{omega_shape}{Beta shape hyper-priors for prior on rate of pathogenicity amongst variants.}

\item{variant_weights}{Vector of log-odds off-sets for rates of pathogenicity of individual variants relative to the global rate, omega.}

\item{estimate_phi}{Logical value determining whether to estimate a scaling factor of \code{variant_weights}.}

\item{samples}{Number of samples to draw.}

\item{burn}{Number of samples to drop from the start of the chain.}

\item{just_Z}{Logical value determining whether to only return the matrix of Z-samples.}
}
\description{
Samples the posterior of the variant-level pathogenicity model using a Gibbs sampling based MCMC routine.
}

