% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphhelpfns.R
\name{compareDAGs}
\alias{compareDAGs}
\title{Comparing two DAGs}
\usage{
compareDAGs(eDAG, trueDAG)
}
\arguments{
\item{eDAG}{an object of class \code{\link[graph]{graphNEL}} (package `graph'), representing the DAG which should be compared to a ground truth DAG or an ajacency matrix corresponding to the DAG}

\item{trueDAG}{an object of class \code{\link[graph]{graphNEL}} (package `graph'), representing the ground truth DAG or an ajacency matrix corresponding to the DAG}
}
\value{
a vector of 5: SHD, number of true positive edges, number of false positive edges, number of false negative edges and true positive rate
}
\description{
This function compares one (estimated) DAG to another DAG (true DAG), returning a vector of 3 values: structural Hamming distance,
number of true positive edges and number of false positive edges.
}
\examples{
Asiascore<-scoreparameters("bde",Asia)
\dontrun{
eDAG<-orderMCMC(Asiascore)
compareDAGs(eDAG$max$DAG,Asiamat)
}
}
