% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioM2.R
\name{HybaseModel}
\alias{HybaseModel}
\title{Selection of the optimal base model}
\usage{
HybaseModel(
  data = NULL,
  pathlistDB = NULL,
  FeatureAnno = NULL,
  resampling = NULL,
  nfolds = 5,
  classifiers = "liblinear",
  predMode = "probability",
  PathwaySizeUp = 200,
  PathwaySizeDown = 20,
  MinfeatureNum_pathways = 10,
  Add_UnMapped = TRUE,
  Unmapped_num = 300,
  Add_FeartureSelection_Method = "wilcox.test",
  Inner_CV = TRUE,
  inner_folds = 10,
  Stage1_FeartureSelection_Method = "cor",
  cutoff = 0.3,
  Stage2_FeartureSelection_Method = "RemoveHighcor",
  cutoff2 = 0.95,
  cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{data}{The input training dataset. The first column
is the label or the output. For binary classes,
0 and 1 are used to indicate the class member.}

\item{pathlistDB}{A list of pathways with pathway IDs and their
corresponding genes ('entrezID' is used).
For details, please refer to ( data("GO2ALLEGS_BP") )}

\item{FeatureAnno}{The annotation data stored in a data.frame for probe
mapping. It must have at least two columns named 'ID' and 'entrezID'.
(For details, please refer to data( data("MethylAnno") )}

\item{resampling}{Resampling in mlr3verse.}

\item{nfolds}{k-fold cross validation}

\item{classifiers}{A string of character vectors(Learners in mlr3)}

\item{predMode}{The prediction mode. Available options are
c('probability', 'classification').}

\item{PathwaySizeUp}{The upper-bound of the number of genes in each
biological pathways.}

\item{PathwaySizeDown}{The lower-bound of the number of genes in each
biological pathways.}

\item{MinfeatureNum_pathways}{The minimal defined pathway size after mapping your
own data to pathlistDB(KEGG database/GO database).}

\item{Add_UnMapped}{Whether to add unmapped probes for prediction}

\item{Unmapped_num}{The number of unmapped probes}

\item{Add_FeartureSelection_Method}{Feature selection methods.}

\item{Inner_CV}{Whether to perform a k-fold verification on the training set.}

\item{inner_folds}{k-fold verification on the training set.}

\item{Stage1_FeartureSelection_Method}{Feature selection methods.}

\item{cutoff}{The cutoff used for feature selection threshold. It can be any value
between 0 and 1.}

\item{Stage2_FeartureSelection_Method}{Feature selection methods.}

\item{cutoff2}{The cutoff used for feature selection threshold. It can be any value
between 0 and 1.}

\item{cores}{The number of cores used for computation.}

\item{verbose}{Whether to print running process information to the console}
}
\value{
A data frame containing the predictive performance of each basemodel
}
\description{
Selection of the optimal base model
}
