% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/404-extractDrugAminoAcidCount.R
\name{Constitutional}
\alias{Constitutional}
\alias{extrDrugAminoAcidCount}
\alias{extrDrugAromaticAtomsCount}
\alias{extrDrugAromaticBondsCount}
\alias{extrDrugAtomCount}
\alias{extrDrugBondCount}
\alias{extrDrugLargestChain}
\alias{extrDrugLargestPiSystem}
\alias{extrDrugLongestAliphaticChain}
\alias{extrDrugRotatableBondsCount}
\title{Calculates the Number of Amino Acids Descriptor}
\usage{
extrDrugAminoAcidCount(molecules, silent = TRUE)

extrDrugAromaticAtomsCount(molecules, silent = TRUE)

extrDrugAromaticBondsCount(molecules, silent = TRUE)

extrDrugAtomCount(molecules, silent = TRUE)

extrDrugBondCount(molecules, silent = TRUE)

extrDrugLargestChain(molecules, silent = TRUE)

extrDrugLargestPiSystem(molecules, silent = TRUE)

extrDrugLongestAliphaticChain(molecules, silent = TRUE)

extrDrugRotatableBondsCount(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules, 
each column represents one feature. 
This function returns 20 columns named 
\code{nA}, \code{nR}, \code{nN}, \code{nD}, \code{nC},
\code{nF}, \code{nQ}, \code{nE}, \code{nG}, \code{nH}, 
\code{nI}, \code{nP}, \code{nL} \code{nK}, \code{nM}, 
\code{nS}, \code{nT}, \code{nY} \code{nV}, \code{nW}.

A data frame, each row represents one of the molecules, 
each column represents one feature. 
This function returns one column named \code{naAromAtom}.
}
\description{
Calculates the Number of Amino Acids Descriptor

Calculates the Number of Aromatic Atoms Descriptor

Calculates the Number of Aromatic Bonds Descriptor

Calculates the Number of Atom Descriptor

Calculates the Descriptor Based on the Number of Bonds of a 
Certain Bond Order

Descriptor that Calculates the Number of Atoms in the Largest Chain

Descriptor that Calculates the Number of Atoms in the Largest Pi Chain

Descriptor that Calculates the Number of Atoms in the Longest Aliphatic Chain

Descriptor that Calculates the Number of Nonrotatable Bonds on A Molecule
}
\details{
Calculates the number of each amino acids (total 20 types) 
found in the molecues.

Calculates the number of aromatic atoms of a molecule.

Calculates the number of aromatic bonds of a molecule.

Calculates the number of atoms of a certain element type in a molecule. 
By default it returns the count of all atoms.

Calculates the descriptor based on the number of bonds of a 
certain bond order.

This descriptor calculates the number of atoms in the largest chain. 
Note that a chain exists if there are two or more atoms. 
Thus single atom molecules will return \code{0}.

This descriptor calculates the number of atoms in the largest pi chain.

This descriptor calculates the number of atoms in the longest aliphatic chain.

The number of rotatable bonds is given by the SMARTS specified by 
Daylight on SMARTS tutorial
(\url{http://www.daylight.com/dayhtml_tutorials/languages/smarts/smarts_examples.html#EXMPL})
}
\examples{
# Calculates the Number of Amino Acids Descriptor
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugAminoAcidCount(mol)
head(dat)

# Calculates the Number of Aromatic Atoms Descriptor
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugAromaticAtomsCount(mol)
head(dat)

# Calculates the Number of Aromatic Bonds Descriptor
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugAromaticBondsCount(mol)
head(dat)

# Calculates the Number of Atom Descriptor
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugAtomCount(mol)
head(dat)

# Calculates the Descriptor Based on the Number of Bonds of a 
# Certain Bond Order
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugBondCount(mol)
head(dat)

# Descriptor that Calculates the Number of Atoms in the Largest Chain
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugLargestChain(mol)
head(dat)

# Descriptor that Calculates the Number of Atoms in the Largest Pi Chain
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugLargestPiSystem(mol)
head(dat)

# Descriptor that Calculates the Number of Atoms in the Longest Aliphatic Chain
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugLongestAliphaticChain(mol)
head(dat)

# Descriptor that Calculates the Number of Nonrotatable Bonds on A Molecule
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugRotatableBondsCount(mol)
head(dat)

}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{Acid}
\keyword{Aliphatic}
\keyword{Amino}
\keyword{Aromatic}
\keyword{Atom}
\keyword{Atoms}
\keyword{Bond}
\keyword{Bonds}
\keyword{Chain}
\keyword{Count}
\keyword{Largest}
\keyword{Longest}
\keyword{Pi}
\keyword{Rotatable}
\keyword{extrDrugAminoAcidCount}
\keyword{extrDrugAromaticAtomsCount}
\keyword{extrDrugAromaticBondsCount}
\keyword{extrDrugAtomCount}
\keyword{extrDrugBondCount}
\keyword{extrDrugLargestChain}
\keyword{extrDrugLargestPiSystem}
\keyword{extrDrugLongestAliphaticChain}
\keyword{extrDrugRotatableBondsCount}
