% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradientDesc.R
\name{gradientDesc}
\alias{gradientDesc}
\title{Gradient function for Binary Logistic Biplot}
\usage{
gradientDesc(
  x,
  k = 2,
  rate = 0.001,
  converg = 0.001,
  max_iter,
  plot = FALSE,
  ...
)
}
\arguments{
\item{x}{Binary matrix.}

\item{k}{Dimensions number. By default \code{k = 2}.}

\item{rate}{The value of the rate of descent \eqn{\alpha} in the algorithm of descending gradient. By default \eqn{\alpha = 0.001}.}

\item{converg}{Tolerance limit to achieve convergence. By default \code{converg = 0.001}}

\item{max_iter}{Maximum iterations number.}

\item{plot}{Plot the Logistic Biplot.}

\item{...}{other arguments}
}
\value{
The coefficients of A and B matrix.
}
\description{
This function computes the parameters of A and B in Binary Logistic Biplot under algorithm of Descendent Gradient.
}
\details{
We note that the Binary Logistic Biplot is defined as: \deqn{logit(\pi_{ij})= log\left( \frac{\pi_{ij}}{1-\pi_{ij}} \right)=\mu_{j}+\sum_{s=1}^kb_{js}a_{is} = \mu_{j}+\mathbf{a_i^{T}b_j}}
Also, note that the gradient is: \deqn{\nabla \ell= \left(\frac{\partial \ell}{\partial \mu}, \frac{\partial \ell}{\partial \mathbf{A}}, \frac{\partial \ell}{\partial \mathbf{B}}\right)== \left( (\Pi - \mathbf{X})^T,  (\Pi - \mathbf{X})\mathbf{B}, (\Pi - \mathbf{X})^TA  \right)}
}
\examples{
data('Methylation')
set.seed(02052020)
MatGD <- gradientDesc(x = Methylation, k=2, max_iter=10000)
outGD <- gradientDesc(x = Methylation, k=2, max_iter=10000, plot = TRUE)
}
\references{
Vicente-Villardon, J.L. and Galindo, M. Purificacion (2006), \emph{Multiple Correspondence Analysis and related Methods. Chapter: Logistic Biplots}. Chapman-Hall
}
\seealso{
\code{\link{plotBLB}, \link{performanceBLB}}
}
\author{
Giovany Babativa <gbabativam@gmail.com>
}
