% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_based.R
\name{SemisupervisedTransformBulk}
\alias{SemisupervisedTransformBulk}
\title{Transforms bulk expression of a gene using only single-cell data}
\usage{
SemisupervisedTransformBulk(gene, Y.train, X.pred)
}
\arguments{
\item{gene}{Character string. Gene name that corresponds to row in Y.train}

\item{Y.train}{Numeric Matrix. Number of gene rows by number of overlapping
individuals columns. Contains weighted sum of reference profile by 
single-cell based cell proportion estimates for each individual}

\item{X.pred}{Numeric Matrix. Number of gene rows by number of remaining
individuals columns. Contains observed bulk expression for each individual
to be transformed.}
}
\value{
Y.pred Numeric Matrix. One row for given gene by number of remaining
  individuals columns. Contains transformed bulk expression for each
  individual.
}
\description{
For a specific gene, this function learns a transformation of
the bulk expression to match the distribution produced
by the single-cell based reference and observed single-cell based cell
proportions.
}
