% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trandapters.R
\name{imputeTransdapter}
\alias{imputeTransdapter}
\title{Impute transdapter}
\usage{
imputeTransdapter(adapter = getImpRfZ)
}
\arguments{
\item{adapter}{importance adapter to transform.}
}
\value{
transformed importance adapter which can be fed into \code{getImp} argument of the \code{\link{Boruta}} function.
}
\description{
Wraps the importance adapter to accept NAs in input.
}
\note{
An all-NA feature will be converted to all zeroes, which should be ok as a totally non-informative value with most methods, but it is not universally correct.
Ideally, one should avoid having such features in input altogether.
}
\examples{
\dontrun{
set.seed(777)
data(srx)
srx_na<-srx
# Randomly punch 25 holes in the SRX data
holes<-25
holes<-cbind(
 sample(nrow(srx),holes,replace=TRUE),
 sample(ncol(srx),holes,replace=TRUE)
)
srx_na[holes]<-NA
# Use impute transdapter to mitigate them with internal imputation
Boruta(Y~.,data=srx_na,getImp=imputeTransdapter(getImpRfZ))
}
}
