% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bound_EE1.R
\name{Bound_EE1}
\alias{Bound_EE1}
\title{Uniform bound on Edgeworth expansion}
\usage{
Bound_EE1(
  setup = list(continuity = FALSE, iid = FALSE, no_skewness = FALSE),
  n,
  K4 = 9,
  K3 = NULL,
  lambda3 = NULL,
  K3tilde = NULL,
  regularity = list(C0 = 1, p = 2),
  eps = 0.1
)
}
\arguments{
\item{setup}{logical vector of size 3 made up of
the following components: \itemize{
   \item \code{continuity}: if \code{TRUE}, assume that the distribution is continuous.

   \item \code{iid}: if \code{TRUE}, assume that the random variables are i.i.d.

   \item \code{no_skewness}: if \code{TRUE}, assume that the distribution is unskewed.
}}

\item{n}{sample size ( = number of random variables that appear in the sum).}

\item{K4}{bound on the 4th normalized moment of the random variables.
We advise to use K4 = 9 as a general case which covers most ``usual'' distributions.}

\item{K3}{bound on the 3rd normalized moment.
If not given, an upper bound on \code{K3} will be derived from the value of \code{K4}.}

\item{lambda3}{(average) skewness of the variables.
If not given, an upper bound on \mjseqn{abs(lambda3)}
will be derived from the value of \code{K4}.}

\item{K3tilde}{value of
\mjtdeqn{K_{3,n} + \frac{1}{n}\sum_{i=1}^n
E|X_i| \sigma_{X_i}^2 / \overline{B}_n^3}{
K_{3,n} + \frac{1}{n}\sum_{i=1}^n
\mathbb{E}|X_i| \sigma_{X_i}^2 / \overline{B}_n^3}{
K_{3,n} + \frac{1}{n}\sum_{i=1}^n E|X_i| \sigma_{X_i}^2 / \overline{B}_n^3}
where \mjseqn{\overline{B}_n := \sqrt{(1/n) \sum_{i=1}^n E[X_i^2]}}.
If not given, an upper bound on \code{K3tilde} will be derived
from the value of \code{K4}.}

\item{regularity}{list of length up to 3
(only used in the \code{continuity=TRUE} framework)
with the following components:\itemize{

   \item \code{C0} and \code{p}: only used in the \code{iid=FALSE} case.
   It corresponds to the assumption of a polynomial bound on \mjseqn{f_{S_n}}:
   \mjseqn{|f_{S_n}(u)| \leq C_0 \times u^{-p}} for every \mjseqn{u > a_n},
   where \mjseqn{a_n := 2 t_1^* \pi \sqrt{n} / K3tilde}.

   \item \code{kappa}: only used in the \code{iid=TRUE} case.
   Corresponds to a bound on the modulus of the characteristic function of
   the standardized \mjseqn{X_n}. More precisely, \code{kappa} is an upper bound on
   \mjseqn{kappa :=} sup of modulus of \mjseqn{f_{X_n / \sigma_n}(t)}
   over all \mjseqn{t} such that \mjseqn{|t| \geq 2 t_1^* \pi / K3tilde}.
}}

\item{eps}{a value between 0 and 1/3 on which several terms depends.
Any value of \code{eps} will give a valid upper bound but some may give
tighter results than others.}
}
\value{
A vector of the same size as \code{n} with values \mjseqn{\delta_n}
such that
\mjtdeqn{\sup_{x \in R}
\left| \textrm{Prob}(S_n \leq x) - \Phi(x)
- \frac{\lambda_{3,n}}{6\sqrt{n}}(1-x^2) \varphi(x) \right|
\leq \delta_n.}{
\sup_{x \in \mathbb{R}}
\left| \textrm{Prob}(S_n \leq x) - \Phi(x)
- \frac{\lambda_{3,n}}{6\sqrt{n}}(1-x^2) \varphi(x) \right|
\leq \delta_n.}{
\sup_{x \in R} | Prob(S_n \leq x) - \Phi(x)
- \frac{\lambda_{3,n}}{6\sqrt{n}}(1-x^2) \varphi(x) |
\leq \delta_n.}
}
\description{
This function computes a non-aymptotically uniform bound on
the difference between the cdf of a normalized sum of random varialbles
and its 1st order Edgeworth expansion.
It returns a valid value \mjseqn{\delta_n} such that
\mjtdeqn{\sup_{x \in R}
\left| \textrm{Prob}(S_n \leq x) - \Phi(x)
- \frac{\lambda_{3,n}}{6\sqrt{n}}(1-x^2) \varphi(x) \right|
\leq \delta_n,}{
\sup_{x \in \mathbb{R}}
\left| \textrm{Prob}(S_n \leq x) - \Phi(x)
- \frac{\lambda_{3,n}}{6\sqrt{n}}(1-x^2) \varphi(x) \right|
\leq \delta_n,}{
\sup_{x \in R} | Prob(S_n \leq x) - \Phi(x)
- \frac{\lambda_{3,n}}{6\sqrt{n}}(1-x^2) \varphi(x) |
\leq \delta_n,}
where \mjseqn{X_1, \dots, X_n} be \mjseqn{n} independent centered variables,
and \mjseqn{S_n} be their normalized sum, in the sense that
\mjseqn{S_n := \sum_{i=1}^n X_i / \textrm{sd}(\sum_{i=1}^n X_i)}.
Here \mjseqn{\lambda_{3,n}} denotes the average skewness of
the variables \mjseqn{X_1, \dots, X_n}.
}
\details{
\loadmathjax

Note that the variables \mjseqn{X_1, \dots, X_n} must be independent
but may have different distributions (if \code{setup$iid = FALSE}).
}
\examples{
setup = list(continuity = TRUE, iid = FALSE, no_skewness = TRUE)
regularity = list(C0 = 1, p = 2)

computedBound <- Bound_EE1(
  setup = setup, n = c(150, 2000), K4 = 9,
  regularity = regularity, eps = 0.1 )

setup = list(continuity = TRUE, iid = TRUE, no_skewness = TRUE)
regularity = list(kappa = 0.99)

computedBound2 <- Bound_EE1(
  setup = setup, n = c(150, 2000), K4 = 9,
  regularity = regularity, eps = 0.1 )

setup = list(continuity = FALSE, iid = FALSE, no_skewness = TRUE)

computedBound3 <- Bound_EE1(
  setup = setup, n = c(150, 2000), K4 = 9, eps = 0.1 )

setup = list(continuity = FALSE, iid = TRUE, no_skewness = TRUE)

computedBound4 <- Bound_EE1(
  setup = setup, n = c(150, 2000), K4 = 9, eps = 0.1 )

print(computedBound)
print(computedBound2)
print(computedBound3)
print(computedBound4)

}
\references{
Derumigny A., Girard L., and Guyonvarch Y. (2021).
Explicit non-asymptotic bounds for the distance to the first-order Edgeworth expansion,
ArXiv preprint \href{https://arxiv.org/abs/2101.05780}{arxiv:2101.05780}.
}
\seealso{
\code{\link{Bound_BE}()} for a Berry-Esseen bound.
}
