% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryBranchGLMVS.R
\name{summary.BranchGLMVS}
\alias{summary.BranchGLMVS}
\title{Summary Method for BranchGLMVS}
\usage{
\method{summary}{BranchGLMVS}(object, ...)
}
\arguments{
\item{object}{a \code{BranchGLMVS} object.}

\item{...}{further arguments passed to other methods.}
}
\value{
An object of class \code{summary.BranchGLMVS} which is a list with the 
following components
\item{\code{results}}{ a data frame which has the metric values for the best models along 
with the variables included in each model}
\item{\code{initmodel}}{ the initial \code{BranchGLM} object that was supplied to the 
\code{VariableSelection} function}
\item{\code{VS}}{ the supplied \code{BranchGLMVS} object}
\item{\code{formulas}}{ a list containing the formulas of the best models}
\item{\code{metric}}{ the metric used to perform variable selection}
}
\description{
Summary Method for BranchGLMVS
}
\examples{

Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", 
bestmodels = 10, showprogress = FALSE)
VS

## Getting summary of the process
Summ <- summary(VS)
Summ

## Plotting the BIC of the best models
plot(Summ, type = "b")

## Plotting the variables in the best models
plot(Summ, ptype = "variables")

## Getting coefficients
coef(Summ)
 
}
