% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radiation_parameters.R
\name{rso_calculation_1}
\alias{rso_calculation_1}
\title{Clear-sky solar radiation with calibrated values available}
\usage{
rso_calculation_1(as, bs, ra)
}
\arguments{
\item{as}{A dataframe with latitude in decimal degrees that you want to calculate the ra. The values of as = 0.25 is recommended by Allen et al. (1998).}

\item{bs}{A dataframe with the dates that you want to calculate the ra. The values of bs = 0.50 is recommended by Allen et al. (1998).}

\item{ra}{Extraterrestrial radiation for daily periods (ra).}
}
\value{
A data.frame object with the clear-sky radiation data
}
\description{
Clear-sky solar radiation is calculated in this function for near sea level or when calibrated values for as and bs are available.
}
\examples{
\dontrun{
rso_df <- rso_calculation_1(as, bs, ra)
}
}
\author{
Roberto Filgueiras, Luan P. Venancio, Catariny C. Aleman and Fernando F. da Cunha
}
