% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_file.R
\name{extract_file}
\alias{extract_file}
\title{Extract file}
\usage{
extract_file(url, file, token, wait = 60)
}
\arguments{
\item{url}{The URL to the Brown Dog server to use.}

\item{file}{The input file could be URL or file with the path}

\item{token}{Brown Dog access token}

\item{wait}{The amount of time to wait for the DTS to respond. Default is 60 seconds}
}
\value{
The extracted metadata in JSON format
}
\description{
Extract content-based metadata from the given input file's content using Brown Dog extraction service
}
\examples{
\dontrun{
key <- get_key("https://bd-api-dev.ncsa.illinois.edu", "your email", "password")
token <- get_token("https://bd-api-dev.ncsa.illinois.edu", key)
extract_file("https://bd-api-dev.ncsa.illinois.edu", 
"http://browndog.ncsa.illinois.edu/examples/gi/Dongying_sample.csv", token)
}
}
