% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCT_Valid.R
\name{validFCTs}
\alias{validCharacter}
\alias{validClass}
\alias{validDimension}
\alias{validFCTs}
\alias{validInteger}
\alias{validLogical}
\alias{validNames}
\alias{validNumeric}
\alias{validPath}
\title{Check argument in functions}
\usage{
validCharacter(value1, name1 = as.character(substitute(value1)), validLength,
  validValues = "character", refuse.NULL = TRUE,
  refuse.duplicates = FALSE, method = NULL, addPP = TRUE)

validClass(value1, name1 = as.character(substitute(value1)), validClass,
  superClasses = TRUE, method = NULL, addPP = TRUE)

validDimension(value1, value2 = NULL,
  name1 = as.character(substitute(value1)),
  name2 = as.character(substitute(value2)), validDimension = NULL,
  type = c("NROW", "NCOL"), method = NULL, addPP = TRUE)

validInteger(value1, name1 = as.character(substitute(value1)), validLength,
  validValues = NULL, min = NULL, max = NULL, refuse.NA = TRUE,
  refuse.NULL = TRUE, refuse.duplicates = FALSE, method = NULL,
  addPP = TRUE)

validLogical(value1, name1 = as.character(substitute(value1)), validLength,
  refuse.NULL = TRUE, refuse.NA = TRUE, method = NULL, addPP = TRUE)

validNames(value1, name1 = as.character(substitute(value1)),
  refuse.NULL = TRUE, validLength = NULL, validValues = NULL,
  requiredValues = NULL, refuse.values = NULL, method = NULL,
  addPP = TRUE)

validNumeric(value1, name1 = as.character(substitute(value1)), validLength,
  validValues = NULL, min = NULL, max = NULL, refuse.NA = TRUE,
  refuse.NULL = TRUE, refuse.duplicates = FALSE, method = NULL,
  addPP = TRUE)

validPath(value1, name1 = as.character(substitute(value1)), type,
  method = NULL, addPP = TRUE, extension = NULL, checkFsep = FALSE)
}
\arguments{
\item{value1}{the value of the (first) argument to be checked}

\item{name1}{the name of the (first) argument.}

\item{validLength}{the acceptable length(s) for the argument. If \code{NULL} no test is performed.}

\item{validValues}{the acceptable value(s) for the argument. If \code{NULL} no test is performed. Can also be "character" or "character_or_logical".}

\item{refuse.NULL}{should an error be output if value is \code{NULL}.}

\item{refuse.duplicates}{should an error be output if value contains duplicated values.}

\item{method}{the name of the function using the argument.}

\item{addPP}{add ": " after the name of the function in the error message.}

\item{validClass}{the acceptable classes(s) for the argument.}

\item{superClasses}{uses the \code{is} function instead of \code{class} to test the class of the object.}

\item{value2}{the second value of a second argument whose dimensions should be consistent with the first one}

\item{name2}{the name of the second argument.}

\item{validDimension}{the acceptable dimension for the argument. If \code{NULL} then name2 is used as a reference.}

\item{type}{For \code{validDimension}: the type of operator used to check the dimensions. For \code{validPath} either "dir" or "file" to check whether to path points to an existing directory or file.}

\item{min}{the minimum acceptable value}

\item{max}{the maximum acceptable value}

\item{refuse.NA}{should an error be output if value contains \code{NA}.}

\item{requiredValues}{values that must appear in the argument}

\item{refuse.values}{values that must not appear in the argument}

\item{extension}{check that the file has the specified extension (excluding \code{.}).}

\item{checkFsep}{check whether the path ends with a separator.}
}
\value{
An invisible \code{TRUE} or an error message.
}
\description{
Check the validity of the arguments in functions
}
\keyword{check}
\keyword{function}

