% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normexp.R
\name{pnormexp}
\alias{pnormexp}
\title{Cumulative Distribution Function of a Gaussian Variable Plus an Exponential Variable}
\usage{
pnormexp(q, rate, rho)
}
\description{
Cumulative Distribution Function of a Gaussian Variable Plus an Exponential Variable
}
\examples{
\dontrun{
n <- 1e6

## rho > 0
mean(rnorm(n) + 1.5 * rexp(n, rate = 2) <= 0.1)
pnormexp(0.1, rate = 2, rho = 1.5)
mean(rnorm(n) + 1.5 * rexp(n, rate = 2) <= 0.9)
pnormexp(0.9, rate = 2, rho = 1.5)

## rho < 0
mean(rnorm(n) - 1.5 * rexp(n, rate = 2) <= 0.1)
pnormexp(0.1, rate = 2, rho = -1.5)
mean(rnorm(n) - 1.5 * rexp(n, rate = 2) <= 0.9)
pnormexp(0.9, rate = 2, rho = -1.5)
}
}
\keyword{internal}
