% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuyseTest-get.R
\docType{methods}
\name{getPseudovalue}
\alias{getPseudovalue}
\alias{getPseudovalue,S4BuyseTest-method}
\title{Extract the pseudovalues of the Estimator}
\usage{
\S4method{getPseudovalue}{S4BuyseTest}(object, statistic = NULL, endpoint = NULL)
}
\arguments{
\item{object}{an \R object of class \code{\linkS4class{S4BuyseTest}}, i.e., output of \code{\link{BuyseTest}}}

\item{statistic}{[character] the type of statistic relative to which the pseudovalues should be computed.
Can be \code{"netBenefit"}, \code{"winRatio"}, \code{"favorable"}, or \code{"unfavorable"}.}

\item{endpoint}{[character] for which endpoint(s) the pseudovalues should be output?
If \code{NULL} returns the sum of the H-decomposition over all endpoints.}
}
\description{
Extract the pseudovalues of the estimator.
The average of the pseudovalues is the estimate and their standard deviation the standard error of the estimate times a factor n
(i.e. a t-test on their mean will give asymptotically valid confidence intervals and p-values).
}
\examples{
set.seed(10)
n <- 250
d <- simBuyseTest(n)

e.BT <- BuyseTest(treatment ~ tte(eventtime,status,2) + bin(toxicity),
                 data = d, trace = 0)

#### net Benefit
pseudo <- getPseudovalue(e.BT)
summary(lm(pseudo~1))$coef
## asymptotically equivalent to
confint(e.BT, transformation = TRUE)
## (small differences: small sample corrections)

summary(lm(getPseudovalue(e.BT, endpoint = 1)~1))$coef

#### win Ratio
pseudo <- getPseudovalue(e.BT, statistic = "winRatio")
summary(lm(pseudo~1))$coef ## wrong p-value (should compare to 1 instead of 0)
## asymptotically equivalent to
confint(e.BT, statistic = "winRatio", transformation = TRUE)

#### favorable
pseudo <- getPseudovalue(e.BT, statistic = "favorable")
summary(lm(pseudo~1))$coef ## wrong p-value (should compare to 1/2 instead of 0)
## asymptotically equivalent to
confint(e.BT, statistic = "favorable", transformation = TRUE)

#### unfavorable
pseudo <- getPseudovalue(e.BT, statistic = "unfavorable")
summary(lm(pseudo~1))$coef ## wrong p-value (should compare to 1/2 instead of 0)
## asymptotically equivalent to
confint(e.BT, statistic = "unfavorable", transformation = TRUE)
}
\seealso{
\code{\link{BuyseTest}} for performing a generalized pairwise comparison. \cr
\code{\link{S4BuyseTest-summary}} for a more detailed presentation of the \code{S4BuyseTest} object.
}
\author{
Brice Ozenne
}
\keyword{method}
