/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.prefs.DataPointColor;
import org.neptuneinc.cadstat.prefs.PlotCharacter;
import org.neptuneinc.cadstat.prefs.PreferencesManager;

public class PreferencesDialog
extends JDialog
implements ActionListener,
ChangeListener {
    public static final Float MAGNIFICATION_FACTOR = Float.valueOf(4.0f);
    private PreferencesManager prefsManager;
    private boolean settingsChanged;
    private JButton applyButton;
    private JPanel buttonPane;
    private JButton cancelButton;
    private JComboBox dataPointColor;
    private JPanel generalPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JSlider magAxis;
    private JSlider magAxisLabel;
    private JSlider magDataPoint;
    private JPanel magPane;
    private JSlider magPlotTitle;
    private JComboBox plotChar;
    private JPanel plotPane;
    private JButton saveButton;
    private JTabbedPane tabbedPane;

    public PreferencesDialog() {
        this.initComponents();
        this.initCustom();
    }

    protected void initCustom() {
        this.dataPointColor.setModel(new DefaultComboBoxModel<DataPointColor>(DataPointColor.values()));
        this.plotChar.setModel(new DefaultComboBoxModel<PlotCharacter>(PlotCharacter.values()));
        this.prefsManager = new PreferencesManager();
        this.importPreferences();
        this.dataPointColor.addActionListener(this);
        this.plotChar.addActionListener(this);
        this.magPlotTitle.addChangeListener(this);
        this.magAxis.addChangeListener(this);
        this.magAxisLabel.addChangeListener(this);
        this.magDataPoint.addChangeListener(this);
        this.setSettingsChanged(false);
        this.updateValidity();
        this.getRootPane().setDefaultButton(this.saveButton);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.plotPane = new JPanel();
        this.generalPane = new JPanel();
        this.jLabel1 = new JLabel();
        this.dataPointColor = new JComboBox();
        this.jLabel2 = new JLabel();
        this.plotChar = new JComboBox();
        this.magPane = new JPanel();
        this.jLabel4 = new JLabel();
        this.magPlotTitle = new JSlider();
        this.jLabel5 = new JLabel();
        this.magAxis = new JSlider();
        this.jLabel6 = new JLabel();
        this.magAxisLabel = new JSlider();
        this.jLabel7 = new JLabel();
        this.magDataPoint = new JSlider();
        this.buttonPane = new JPanel();
        this.cancelButton = new JButton();
        this.saveButton = new JButton();
        this.applyButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Preferences");
        this.generalPane.setBorder(BorderFactory.createTitledBorder("General"));
        this.jLabel1.setLabelFor(this.dataPointColor);
        this.jLabel1.setText("Data Point Color");
        this.jLabel2.setLabelFor(this.plotChar);
        this.jLabel2.setText("Plotting Character");
        GroupLayout generalPaneLayout = new GroupLayout((Container)this.generalPane);
        this.generalPane.setLayout((LayoutManager)generalPaneLayout);
        generalPaneLayout.setHorizontalGroup((GroupLayout.Group)generalPaneLayout.createParallelGroup(1).add((GroupLayout.Group)generalPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)generalPaneLayout.createParallelGroup(1).add((GroupLayout.Group)generalPaneLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.plotChar, 0, 149, Short.MAX_VALUE)).add((GroupLayout.Group)generalPaneLayout.createSequentialGroup().add((Component)this.jLabel1).add(21, 21, 21).add((Component)this.dataPointColor, 0, 149, Short.MAX_VALUE))).addContainerGap()));
        generalPaneLayout.setVerticalGroup((GroupLayout.Group)generalPaneLayout.createParallelGroup(1).add((GroupLayout.Group)generalPaneLayout.createSequentialGroup().add((GroupLayout.Group)generalPaneLayout.createParallelGroup(1, false).add((Component)this.jLabel1, -1, -1, Short.MAX_VALUE).add((Component)this.dataPointColor, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)generalPaneLayout.createParallelGroup(3).add((Component)this.plotChar, -2, -1, -2).add((Component)this.jLabel2, -2, 23, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.magPane.setBorder(BorderFactory.createTitledBorder("Magnification"));
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setLabelFor(this.magPlotTitle);
        this.jLabel4.setText("Plot Title");
        this.magPlotTitle.setMajorTickSpacing(2);
        this.magPlotTitle.setMaximum(12);
        this.magPlotTitle.setMinimum(2);
        this.magPlotTitle.setMinorTickSpacing(1);
        this.magPlotTitle.setValue(4);
        this.magPlotTitle.setPreferredSize(new Dimension(80, 16));
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setLabelFor(this.magAxis);
        this.jLabel5.setText("Axis");
        this.magAxis.setMajorTickSpacing(2);
        this.magAxis.setMaximum(12);
        this.magAxis.setMinimum(2);
        this.magAxis.setMinorTickSpacing(1);
        this.magAxis.setValue(4);
        this.magAxis.setPreferredSize(new Dimension(80, 16));
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setLabelFor(this.magAxisLabel);
        this.jLabel6.setText("Axis Label");
        this.magAxisLabel.setMajorTickSpacing(2);
        this.magAxisLabel.setMaximum(12);
        this.magAxisLabel.setMinimum(2);
        this.magAxisLabel.setMinorTickSpacing(1);
        this.magAxisLabel.setValue(4);
        this.magAxisLabel.setPreferredSize(new Dimension(80, 16));
        this.jLabel7.setHorizontalAlignment(2);
        this.jLabel7.setLabelFor(this.magDataPoint);
        this.jLabel7.setText("Data Point");
        this.magDataPoint.setMajorTickSpacing(2);
        this.magDataPoint.setMaximum(12);
        this.magDataPoint.setMinimum(2);
        this.magDataPoint.setMinorTickSpacing(1);
        this.magDataPoint.setValue(4);
        this.magDataPoint.setPreferredSize(new Dimension(80, 16));
        GroupLayout magPaneLayout = new GroupLayout((Container)this.magPane);
        this.magPane.setLayout((LayoutManager)magPaneLayout);
        magPaneLayout.setHorizontalGroup((GroupLayout.Group)magPaneLayout.createParallelGroup(1).add((GroupLayout.Group)magPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)magPaneLayout.createParallelGroup(1).add((GroupLayout.Group)magPaneLayout.createSequentialGroup().add((GroupLayout.Group)magPaneLayout.createParallelGroup(1).add((Component)this.jLabel4).add((Component)this.jLabel5)).add(20, 20, 20).add((GroupLayout.Group)magPaneLayout.createParallelGroup(1).add((Component)this.magAxis, -1, 197, Short.MAX_VALUE).add((Component)this.magPlotTitle, -1, 197, Short.MAX_VALUE))).add((GroupLayout.Group)magPaneLayout.createSequentialGroup().add((GroupLayout.Group)magPaneLayout.createParallelGroup(2).add((Component)this.jLabel7).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)magPaneLayout.createParallelGroup(1).add((Component)this.magDataPoint, -1, 196, Short.MAX_VALUE).add((Component)this.magAxisLabel, -1, 196, Short.MAX_VALUE)))).addContainerGap()));
        magPaneLayout.setVerticalGroup((GroupLayout.Group)magPaneLayout.createParallelGroup(1).add((GroupLayout.Group)magPaneLayout.createSequentialGroup().add((GroupLayout.Group)magPaneLayout.createParallelGroup(1).add((Component)this.jLabel4).add((Component)this.magPlotTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)magPaneLayout.createParallelGroup(1).add((Component)this.jLabel5).add((Component)this.magAxis, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)magPaneLayout.createParallelGroup(2).add((Component)this.jLabel6).add((Component)this.magAxisLabel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)magPaneLayout.createParallelGroup(1).add((Component)this.jLabel7).add((Component)this.magDataPoint, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout plotPaneLayout = new GroupLayout((Container)this.plotPane);
        this.plotPane.setLayout((LayoutManager)plotPaneLayout);
        plotPaneLayout.setHorizontalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add(2, (Component)this.generalPane, -1, -1, Short.MAX_VALUE).add(2, (Component)this.magPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        plotPaneLayout.setVerticalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.generalPane, -2, -1, -2).addPreferredGap(0).add((Component)this.magPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Plot", this.plotPane);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.applyButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonPaneLayout = new GroupLayout((Container)this.buttonPane);
        this.buttonPane.setLayout((LayoutManager)buttonPaneLayout);
        buttonPaneLayout.setHorizontalGroup((GroupLayout.Group)buttonPaneLayout.createParallelGroup(1).add((GroupLayout.Group)buttonPaneLayout.createSequentialGroup().add(30, 30, 30).add((Component)this.cancelButton, -1, 86, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.saveButton, -1, 75, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.applyButton, -1, 81, Short.MAX_VALUE).add(40, 40, 40)));
        buttonPaneLayout.setVerticalGroup((GroupLayout.Group)buttonPaneLayout.createParallelGroup(1).add((GroupLayout.Group)buttonPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)buttonPaneLayout.createParallelGroup(3).add((Component)this.saveButton).add((Component)this.applyButton).add((Component)this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.tabbedPane, -1, 336, Short.MAX_VALUE).add(1, (Component)this.buttonPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.tabbedPane, -1, 265, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.buttonPane, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void importPreferences() {
        try {
            this.prefsManager.importPreferences();
        }
        catch (Exception ex) {
            Logger.getLogger(PreferencesDialog.class.getName()).log(Level.INFO, null, ex);
        }
        this.dataPointColor.setSelectedItem((Object)this.prefsManager.getCadstatPreferences().getDataPointColor());
        this.plotChar.setSelectedItem((Object)this.prefsManager.getCadstatPreferences().getPlotCharacter());
        this.magPlotTitle.setValue(Math.round(this.prefsManager.getCadstatPreferences().getPlotTitleMagnification().floatValue() * MAGNIFICATION_FACTOR.floatValue()));
        this.magAxis.setValue(Math.round(this.prefsManager.getCadstatPreferences().getAxisMagnification().floatValue() * MAGNIFICATION_FACTOR.floatValue()));
        this.magAxisLabel.setValue(Math.round(this.prefsManager.getCadstatPreferences().getAxisLabelMagnification().floatValue() * MAGNIFICATION_FACTOR.floatValue()));
        this.magDataPoint.setValue(Math.round(this.prefsManager.getCadstatPreferences().getDataPointMagnification().floatValue() * MAGNIFICATION_FACTOR.floatValue()));
    }

    private void exportPreferences() {
        this.prefsManager.getCadstatPreferences().setDataPointColor((DataPointColor)((Object)this.dataPointColor.getSelectedItem()));
        this.prefsManager.getCadstatPreferences().setPlotCharacter((PlotCharacter)((Object)this.plotChar.getSelectedItem()));
        this.prefsManager.getCadstatPreferences().setPlotTitleMagnification(Float.valueOf((float)this.magPlotTitle.getValue() / MAGNIFICATION_FACTOR.floatValue()));
        this.prefsManager.getCadstatPreferences().setAxisMagnification(Float.valueOf((float)this.magAxis.getValue() / MAGNIFICATION_FACTOR.floatValue()));
        this.prefsManager.getCadstatPreferences().setAxisLabelMagnification(Float.valueOf((float)this.magAxisLabel.getValue() / MAGNIFICATION_FACTOR.floatValue()));
        this.prefsManager.getCadstatPreferences().setDataPointMagnification(Float.valueOf((float)this.magDataPoint.getValue() / MAGNIFICATION_FACTOR.floatValue()));
        try {
            this.prefsManager.exportPreferences();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void processSettingChange() {
        this.setSettingsChanged(true);
        this.updateValidity();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.processSettingChange();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.processSettingChange();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.exportPreferences();
        this.dispose();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.exportPreferences();
        this.setSettingsChanged(false);
        this.updateValidity();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void updateValidity() {
        this.applyButton.setEnabled(this.isSettingsChanged());
    }

    protected boolean isSettingsChanged() {
        return this.settingsChanged;
    }

    protected void setSettingsChanged(boolean settingsChanged) {
        this.settingsChanged = settingsChanged;
    }
}

