% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_se.R
\name{calc_se}
\alias{calc_se}
\title{Calculates the standard error for simple and percent differences}
\usage{
calc_se(Xk, dif = "simple", comparisons = "all.vs.all",
  method = "param", boot.R = 999)
}
\arguments{
\item{Xk}{list object where each position contains a vector of observations
of algorithm k on a given problem instance.}

\item{dif}{name of the difference for which the SEs are desired.
Accepts "perc" (for percent differences) or "simple" (for simple
differences)}

\item{comparisons}{standard errors to be calculated. Accepts "all.vs.first"
(in which cases the first object in \code{algorithms} is considered to be
the reference algorithm) or "all.vs.all" (if there is no reference
and all pairwise SEs are desired).}

\item{method}{method used to calculate the interval. Accepts "param"
(using parametric formulas based on normality of the sampling
distribution of the means) or "boot" (for bootstrap).}

\item{boot.R}{(optional) number of bootstrap resamples
(if \code{method == "boot"})}
}
\value{
a list object containing the following items:
\itemize{
\item \code{Phi.est} - estimated values of the statistic of interest for
each pair of algorithms of interest (all pairs if \code{comparisons == "all.vs.all"},
or all pairs containing the first algorithm if \code{comparisons == "all.vs.first"}).
\item \code{se} - standard error estimates
}
}
\description{
Calculates the sample standard error for the estimator differences between
multiple algorithms on a given instance.
}
\details{
\itemize{
\item If \code{dif == "perc"} it returns the standard errors for the sample
estimates of pairs
\eqn{(mu2 - mu1) / mu}, where \eqn{mu1, mu2} are the means of the
populations that generated sample vectors \eqn{x1, x2}, and
\item If \code{dif == "simple"} it returns the SE for sample estimator of
\eqn{(mu2 - mu1)}
}
}
\section{References}{

\itemize{
\item F. Campelo, F. Takahashi:
Sample size estimation for power and accuracy in the experimental
comparison of algorithms. Journal of Heuristics 25(2):305-338, 2019.
}
}

\examples{
# three vectors of normally distributed observations
set.seed(1234)
Xk <- list(rnorm(10, 5, 1),  # mean = 5, sd = 1,
           rnorm(20, 10, 2), # mean = 10, sd = 2,
           rnorm(50, 15, 5)) # mean = 15, sd = 3

calc_se(Xk, dif = "simple", comparisons = "all.vs.all", method = "param")
calc_se(Xk, dif = "simple", comparisons = "all.vs.all", method = "boot")

calc_se(Xk, dif = "perc", comparisons = "all.vs.first", method = "param")
calc_se(Xk, dif = "perc", comparisons = "all.vs.first", method = "boot")

calc_se(Xk, dif = "perc", comparisons = "all.vs.all", method = "param")
calc_se(Xk, dif = "perc", comparisons = "all.vs.all", method = "boot")
}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br},
\email{f.campelo@aston.ac.uk})
}
