% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calf_wrappers.R
\name{calf}
\alias{calf}
\title{calf}
\usage{
calf(data, nMarkers, targetVector, optimize = "pval", verbose = FALSE)
}
\arguments{
\item{data}{Matrix or data frame. First column must contain case/control dummy coded variable (if targetVector = "binary"). Otherwise, first column must contain real number vector corresponding to selection variable (if targetVector = "nonbinary"). All other columns contain relevant markers.}

\item{nMarkers}{Maximum number of markers to include in creation of sum.}

\item{targetVector}{Indicate "binary" for target vector with two options (e.g., case/control). Indicate "nonbinary" for target vector with real numbers.}

\item{optimize}{Criteria to optimize, "pval" or "auc", (if targetVector = "binary") or "corr" (if targetVector = "nonbinary").  Defaults to "pval".}

\item{verbose}{Logical. Indicate TRUE to print activity at each iteration to console. Defaults to FALSE.}
}
\value{
A data frame containing the chosen markers and their assigned weight (-1 or 1)

The optimal AUC, pval, or correlation for the classification.

If targetVector is binary, rocPlot. A plot object from ggplot2 for the receiver operating curve.
}
\description{
Coarse Approximation Linear Function
}
\examples{
calf(data = CaseControl, nMarkers = 6, targetVector = "binary", optimize = "pval")
}
