% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchIndices.R
\name{matchIndices}
\alias{matchIndices}
\title{matchIndices}
\usage{
matchIndices(x, y, z)
}
\arguments{
\item{x}{Target numeric \emph{vector}.}

\item{y}{Reference numeric \emph{vector}.}

\item{z}{A \emph{numeric} element.}
}
\value{
A \emph{list} with selected indices for \emph{x} and \emph{y}.
}
\description{
Matches two vectors with different lengths based on their maximum value.
}
\details{
{Uses Dynamic Time Wrapping (DTW) to match \emph{x} and \emph{y}. \emph{z} determines 
the buffer size - expressed in number of data points - used to search for matching records.}
}
\examples{
{

x <- c(2200, 4500, 4600, 6400, 1600) # target
y <- c(1100, 1150, 1200, 6400, 1600) # reference

i <- matchIndices(x, y, 1) # find best match

# plot x (blue), and selected y (red)
plot(1:5, replicate(5,0), ylim=c(0,10000), type="l") 
lines(i$x, x[i$x], type="l", col="blue")
lines(i$y, y[i$y], type="l", col="red")

}
}
