% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca_percept.R
\name{caPercept}
\alias{caPercept}
\title{Perceptual map-like Correspondence Analysis scatterplot}
\usage{
caPercept(data, x = 1, y = 2, focus = "row", dim.corr = x,
  guide = FALSE, size.labls = 3)
}
\arguments{
\item{data}{Contingency table, in dataframe format.}

\item{x}{First dimensions to be plotted.}

\item{y}{Second dimensions to be plotted.}

\item{focus}{Takes "row" (default) if the interest is in assessing the
contribution of the rows to the definition of the dimensions, "col" if the
interest is on the columns.}

\item{dim.corr}{Dimension for which the points' correlation (column points if
focus is set to "row", row points if focus is set to "col") will be
computed and used as input value for the size of the points. The default
value is the smaller of the two input dimensions (i.e., x).}

\item{guide}{TRUE or FALSE (default) if the user does or doesn't want the
points being given a color code indicating with which of the two selected
dimension they have a higher relative correlation.}

\item{size.labls}{Adjust the size of the characters used in the labels that
give names to the axes.}
}
\description{
This command allows to plot a variant of the traditional Correspondence
Analysis scatterplots that allows facilitating the interpretation of the
results. It aims at producing what in marketing research is called perceptual
map, a visual representation of the CA results that seeks to avoid the
problem of interpreting inter-spatial distance. It represents only one type
of points (say, column points), and "gives names to the axes" corresponding
to the major row category contributors to the two selected dimensions.
}
\examples{
data(brand_coffee)

caPercept(brand_coffee,1,2,focus="col",dim.corr=1, guide=FALSE)

#In the returned plot, axes are given names according to the major contributing column categories 
# (i.e., coffee brands in this datset), while the points correspond to the row categories 
#(i.e., attributes). Points' size is proportional to the correlation of points with the 1st 
#dimension. If 'guide' is set to TRUE, the returned plot is similar to the preceding one, 
# but the points are given colour according to whether they are more correlated 
# (in relative terms) to the first or to the second of the selected dimensions. 
# In this example, points flagged with "->Dim 1" are more correlated to the 1st dimension, 
# while those flagged with "->Dim 2" have a higher correlation with the 2nd dimension.

}
\seealso{
\code{\link{caPlot}}
}
\keyword{caPercept}
