% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca_scatter.r
\name{caScatter}
\alias{caScatter}
\title{Scatterplot visualization facility}
\usage{
caScatter(data, x = 1, y = 2, type)
}
\arguments{
\item{data}{Name of the contingency table (must be in dataframe format).}

\item{x}{First dimension to be plotted (x=1 by default).}

\item{y}{Second dimensions to be plotted (y=2 by default).}

\item{type}{Type of scatterplot to be returned (see examples).}
}
\description{
This function allows to get different types of CA scatterplots. It is just a wrapper for
functions from the 'ca' and 'FactoMineR' packages.
}
\examples{
data(greenacre_data)

# symmetric scatterplot for rows and columns
caScatter(greenacre_data, 1, 2, type=1) 

# Standard Biplot; 2 plots are returned:
#one with row-categories vectors displayed, one for columns categories vectors.
caScatter(greenacre_data, 1, 2, type=2) 

# scaterplot of row categories with groupings
#shown by different colors; scatterplot for column categories is also returned
caScatter(greenacre_data, 1, 2, type=3) 

# 3D scatterplot with cluster tree for row categories;
#scatterplot for column categories is also returned.
caScatter(greenacre_data, 1, 2, type=4) 

}
\seealso{
\code{\link{caPlot}} , \code{\link{caPercept}} , \code{\link{caPlus}} ,
  \code{\link[ca]{ca}} , \code{\link[FactoMineR]{plot.CA}} , \code{\link[FactoMineR]{HCPC}}
}
\keyword{caScatter}
