% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBDA_Top_Ranked.R
\name{CBDA_Top_Ranked}
\alias{CBDA_Top_Ranked}
\title{CBDA Top-Ranked selection function for Compressive Big Data Analytics}
\usage{
CBDA_Top_Ranked(top_new = 500, label = "CBDA_package_test", Kcol_min = 5,
  Kcol_max = 15, Nrow_min = 30, Nrow_max = 50, misValperc = 0,
  M = 3000, workspace_directory = getwd())
}
\arguments{
\item{top_new}{The new value for the Top predictions to select out of the M}

\item{label}{This is the label appended to RData workspaces generated within the CBDA calls}

\item{Kcol_min}{Lower bound for the percentage of features-columns sampling (used for the Feature Sampling Range - FSR)}

\item{Kcol_max}{Upper bound for the percentage of features-columns sampling (used for the Feature Sampling Range - FSR)}

\item{Nrow_min}{Lower bound for the percentage of cases-rows sampling (used for the Case Sampling Range - CSR)}

\item{Nrow_max}{Upper bound for the percentage of cases-rows sampling (used for the Case Sampling Range - CSR)}

\item{misValperc}{Percentage of missing values to introduce in BigData (used just for testing, to mimic real cases).}

\item{M}{Number of the BigData subsets on which perform Knockoff Filtering and SuperLearner feature mining}

\item{workspace_directory}{Directory where the results and workspaces are saved}
}
\value{
value
}
\description{
This CBDA function has all the features of the *Consolidation()* function but allows to choose a
 different **top** value (i.e., different from the one specified in the main *CBDA()* function
}
