% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBDA_Validation.pipeline.R
\name{CBDA_Validation.pipeline}
\alias{CBDA_Validation.pipeline}
\title{CBDA Validation function for Compressive Big Data Analytics -  LONI pipeline version}
\usage{
CBDA_Validation.pipeline(job_id_val, Ytemp, Xtemp,
  label = "CBDA_package_test", alpha = 0.2, Kcol_min = 5, Kcol_max = 15,
  Nrow_min = 30, Nrow_max = 50, misValperc = 0, M = 3000, N_cores = 1,
  top = 1000, workspace_directory = tempdir(), max_covs = 100,
  min_covs = 5)
}
\arguments{
\item{job_id_val}{This is the ID for the job generator in the LONI pipeline interface}

\item{Ytemp}{This is the output variable (vector) in the original Big Data}

\item{Xtemp}{This is the input variable (matrix) in the original Big Data}

\item{label}{This is the label appended to RData workspaces generated within the CBDA calls}

\item{alpha}{Percentage of the Big Data to hold off for Validation}

\item{Kcol_min}{Lower bound for the percentage of features-columns sampling (used for the Feature Sampling Range - FSR)}

\item{Kcol_max}{Upper bound for the percentage of features-columns sampling (used for the Feature Sampling Range - FSR)}

\item{Nrow_min}{Lower bound for the percentage of cases-rows sampling (used for the Case Sampling Range - CSR)}

\item{Nrow_max}{Upper bound for the percentage of cases-rows sampling (used for the Case Sampling Range - CSR)}

\item{misValperc}{Percentage of missing values to introduce in BigData (used just for testing, to mimic real cases).}

\item{M}{Number of the BigData subsets on which perform Knockoff Filtering and SuperLearner feature mining}

\item{N_cores}{Number of Cores to use in the parallel implementation}

\item{top}{Top predictions to select out of the M}

\item{workspace_directory}{Directory where the results and workspaces are saved}

\item{max_covs}{Top features to display and include in the Validation Step where nested models are tested}

\item{min_covs}{Minimum number of top features to include in the initial model for the Validation Step}
}
\value{
value
}
\description{
This CBDA function generates *max_covs - min_covs* nested models based on the ranking
 returned by the *Consolidation* function. It also consolidates all the *max_covs - min_covs*
 workspaces into a single one.
}
