% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_PolyGrids}
\alias{create_PolyGrids}
\title{Create a Polygon Grid}
\usage{
create_PolyGrids(
  Input,
  NamesIn = NULL,
  dlon = NA,
  dlat = NA,
  Area = NA,
  cuts = 100,
  cols = c("green", "yellow", "red")
)
}
\arguments{
\item{Input}{input dataframe.

\strong{If \code{NamesIn} is not provided, the columns in the \code{Input} must be in the following order:

Latitude, Longitude, Variable 1, Variable 2 ... Variable x.}}

\item{NamesIn}{character vector of length 2 specifying the column names of Latitude and Longitude fields in
the \code{Input}. \strong{Latitudes name must be given first, e.g.:

\code{NamesIn=c('MyLatitudes','MyLongitudes')}}.}

\item{dlon}{numeric, width of the grid cells in decimal degrees of longitude.}

\item{dlat}{numeric, height of the grid cells in decimal degrees of latitude.}

\item{Area}{numeric, area in square kilometers of the grid cells. The smaller the \code{Area}, the longer it will take.}

\item{cuts}{numeric, number of desired color classes.}

\item{cols}{character, desired colors. If more that one color is provided, a linear color gradient is generated.}
}
\value{
Spatial object in your environment.
Data within the resulting spatial object contains the data provided in the \code{Input} after aggregation
within cells. For each Variable, the minimum, maximum, mean, sum, count, standard deviation, and, 
median of values in each cell is returned. In addition, for each cell, its area (AreaKm2), projected 
centroid (Centrex, Centrey) and unprojected centroid (Centrelon, Centrelat) is given.

To see the data contained in your spatial object, type: \code{View(MyGrid)}.

Also, colors are generated for each aggregated values according to the chosen \code{cuts} 
and \code{cols}.

To generate a custom color scale after the grid creation, refer to \code{\link{add_col}} and 
\code{\link{add_Cscale}}. See Example 4 below.
}
\description{
Create a polygon grid to spatially aggregate data in cells of chosen size.
Cell size may be specified in degrees or as a desired area in square kilometers
(in which case cells are of equal area).
}
\examples{
\donttest{


#Example 1: Simple grid, using automatic colors

MyGrid=create_PolyGrids(Input=GridData,dlon=2,dlat=1)
#View(MyGrid)
plot(st_geometry(MyGrid),col=MyGrid$Col_Catch_sum,main="Example 1")

#Example 2: Equal area grid, using automatic colors

MyGrid=create_PolyGrids(Input=GridData,Area=10000)
plot(st_geometry(MyGrid),col=MyGrid$Col_Catch_sum,main="Example 2")

#Example 3: Equal area grid, using custom cuts and colors

MyGrid=create_PolyGrids(Input=GridData,
       Area=10000,cuts=c(0,50,100,500,2000,3500),cols=c('blue','red'))

plot(st_geometry(MyGrid),col=MyGrid$Col_Catch_sum,main="Example 3")

#Example 4: Equal area grid, using custom cuts and colors, and adding a color scale (add_Cscale)

#Step 1: Generate your grid
MyGrid=create_PolyGrids(Input=GridData,Area=10000)

#Step 2: Inspect your gridded data (e.g. sum of Catch) to
#determine whether irregular cuts are required
hist(MyGrid$Catch_sum,100) 
#In this case (heterogeneously distributed data) irregular cuts would be preferable

#Step 3: Generate colors according to the desired classes (cuts)
Gridcol=add_col(MyGrid$Catch_sum,cuts=c(0,50,100,500,2000,3500),cols=c('yellow','purple'))

#Step 4: Plot result and add color scale
Mypar=par(mai=c(0,0,0,2)) #Figure margins as c(bottom, left, top, right)
plot(st_geometry(MyGrid),col=Gridcol$varcol,main="Example 4") #Use the colors generated by add_col
#Add color scale using cuts and cols generated by add_col
add_Cscale(title='Sum of Catch (t)',cuts=Gridcol$cuts,cols=Gridcol$cols,width=24) 
par(Mypar)

}

}
\seealso{
\code{\link{create_Points}}, \code{\link{create_Lines}}, \code{\link{create_Polys}},
\code{\link{create_Stations}}, \code{\link{create_Pies}}, \code{\link{add_col}}, \code{\link{add_Cscale}}.
}
