% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDnetestim.R
\name{cdnet}
\alias{cdnet}
\title{Estimate Count Data Model with Social Interactions using NPL Method}
\usage{
cdnet(
  formula,
  contextual,
  Glist,
  Rbar = NULL,
  starting = list(theta = NULL, delta = NULL),
  yb0 = NULL,
  optimizer = "optim",
  npl.ctr = list(),
  opt.ctr = list(),
  cov = TRUE,
  data
)
}
\arguments{
\item{formula}{an object of class \link[stats]{formula}: a symbolic description of the model. The \code{formula} should be as for example \code{y ~ x1 + x2 | x1 + x2}
where \code{y} is the endogenous vector, the listed variables before the pipe, \code{x1}, \code{x2} are the individual exogenous variables and
the listed variables after the pipe, \code{x1}, \code{x2} are the contextual observable variables. Other formulas may be
\code{y ~ x1 + x2} for the model without contextual effects, \code{y ~ -1 + x1 + x2 | x1 + x2} for the model
without intercept or \code{ y ~ x1 + x2 | x2 + x3} to allow the contextual variable to be different from the individual variables.}

\item{contextual}{(optional) logical; if true, this means that all individual variables will be set as contextual variables. Set the
the \code{formula} as \code{y ~ x1 + x2} and \code{contextual} as \code{TRUE} is equivalent to set the formula as \code{y ~ x1 + x2 | x1 + x2}.}

\item{Glist}{the adjacency matrix or list sub-adjacency matrix.}

\item{Rbar}{the value of Rbar. If not provided, it is automatically set at \code{quantile(y, 0.9)}.}

\item{starting}{(optional) starting value of \eqn{\theta = (\lambda, \beta', \gamma')'} and \eqn{\delta = (\delta_2, ..., \delta_{\bar{R}})}{\delta = (\delta_2, ..., \delta_{Rbar})}. The parameter \eqn{\gamma} should be removed if the model
does not contain contextual effects (see details).}

\item{yb0}{(optional) expectation of y.}

\item{optimizer}{is either \code{nlm} (referring to the \link[stats]{nlm} function) or \code{optim} (referring to the \link[stats]{optim} function).
At every step of the NPL method, the estimation is performed using \link[stats]{nlm} or \link[stats]{optim}. Other arguments
of these functions such as, \code{control} and \code{method} can be defined through the argument \code{opt.ctr}.}

\item{npl.ctr}{list of controls for the NPL method (see details).}

\item{opt.ctr}{list of arguments of \link[stats]{nlm} or \link[stats]{optim} (the one set in \code{optimizer}) such as control, method, ...}

\item{cov}{a boolean indicating if the covariance should be computed.}

\item{data}{an optional data frame, list or environment (or object coercible by \link[base]{as.data.frame} to a data frame) containing the variables
in the model. If not found in data, the variables are taken from \code{environment(formula)}, typically the environment from which \code{cdnet} is called.}
}
\value{
A list consisting of:
\item{info}{list of general information about the model.}
\item{estimate}{NPL estimator.}
\item{yb}{ybar (see details), expectation of y.}
\item{Gyb}{average of the expectation of y among friends.}
\item{cov}{list of covariance matrices.}
\item{details}{step-by-step output as returned by the optimizer.}
}
\description{
Estimate Count Data Model with Social Interactions using NPL Method
}
\details{
\subsection{Model}{

Following Houndetoungan (2020), the count data \eqn{\mathbf{y}}{y} is generated from a latent variable \eqn{\mathbf{y}^*}{ys}.
The latent variable is given for all i as
\deqn{y_i^* = \lambda \mathbf{g}_i \bar{\mathbf{y}} + \mathbf{x}_i'\beta + \mathbf{g}_i\mathbf{X}\gamma + \epsilon_i,}{ys_i = \lambda g_i*ybar + x_i'\beta + g_i*X\gamma + \epsilon_i,}
where \eqn{\epsilon_i \sim N(0, 1)}{\epsilon_i --> N(0, 1)}.\cr
Then, \eqn{y_i = r} iff \eqn{a_r \leq y_i^* \leq a_{r+1}}{a_r \le ys_i \le a_{r + 1}}, where
\eqn{a_0 = -\inf}{a_0 = -Inf}, \eqn{a_1 = 0}, \eqn{a_r = \sum_{k = 1}^r\delta_k}{a_r = \delta_1 + ... + \delta_r} if \eqn{1 \leq r \leq \bar{R}}{1 \le r \le Rbar}, and
\eqn{a_r = (r - \bar{R})\delta_{\bar{R}} + a_{\bar{R}}}{a_r = (r - Rbar)\delta_{Rbar} + a_{Rbar}} otherwise.
}

\subsection{\code{npl.ctr}}{

The model parameters is estimated using the Nested Partial Likelihood (NPL) method. This approach
starts with a guess of \eqn{\theta} and \eqn{\bar{y}}{yb} and constructs iteratively a sequence
of \eqn{\theta} and \eqn{\bar{y}}{yb}. The solution converges when the \eqn{L_1}{L} distance
between two consecutive \eqn{\theta} and \eqn{\bar{y}}{yb} is less than a tolerance. \cr
The argument \code{npl.ctr} is an optional list which contain
\itemize{
\item{tol}{ the tolerance of the NPL algorithm (default 1e-4),}
\item{maxit}{ the maximal number of iterations allowed (default 500),}
\item{print}{ a boolean indicating if the estimate should be printed at each step.}
\item{S}{ the number of simulation performed use to compute integral in the covariance by important sampling.}
}
}
}
\examples{
\donttest{
# Groups' size
M      <- 5 # Number of sub-groups
nvec   <- round(runif(M, 100, 1000))
n      <- sum(nvec)

# Parameters
lambda <- 0.4
beta   <- c(1.5, 2.2, -0.9)
gamma  <- c(1.5, -1.2)
delta  <- c(1, 0.87, 0.75, 0.6, 0.4)
theta  <- c(lambda, beta, gamma)

# X
X      <- cbind(rnorm(n, 1, 1), rexp(n, 0.4))

# Network
Glist  <- list()

for (m in 1:M) {
  nm           <- nvec[m]
  Gm           <- matrix(0, nm, nm)
  max_d        <- 30
  for (i in 1:nm) {
    tmp        <- sample((1:nm)[-i], sample(0:max_d, 1))
    Gm[i, tmp] <- 1
  }
  rs           <- rowSums(Gm); rs[rs == 0] <- 1
  Gm           <- Gm/rs
  Glist[[m]]   <- Gm
}


# data
data    <- data.frame(x1 = X[,1], x2 =  X[,2])

rm(list = ls()[!(ls() \%in\% c("Glist", "data", "theta", "delta"))])

ytmp    <- simcdnet(formula = ~ x1 + x2 | x1 + x2, Glist = Glist, theta = theta,
                    delta = delta, data = data)

y       <- ytmp$y

# plot histogram
hist(y, breaks = max(y))

data    <- data.frame(yt = y, x1 = data$x1, x2 = data$x2)
rm(list = ls()[!(ls() \%in\% c("Glist", "data"))])

out   <- cdnet(formula = yt ~ x1 + x2, contextual = TRUE, Glist = Glist, data = data, Rbar = 6)
summary(out)
}
}
\seealso{
\code{\link{sart}}, \code{\link{sar}}, \code{\link{simcdnet}}.
}
