% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxfunc.R
\name{peer.avg}
\alias{peer.avg}
\title{Computing peer averages}
\usage{
peer.avg(Glist, V, export.as.list = FALSE)
}
\arguments{
\item{Glist}{the adjacency matrix or list sub-adjacency matrix.}

\item{V}{vector or matrix of observable characteristics.}

\item{export.as.list}{(optional) boolean to indicate if the output should be a list of matrices or a single matrix.}
}
\value{
the matrix product \code{diag(Glist[[1]], Glist[[2]], ...) \%*\% V}, where \code{diag()} is the block diagonal operator.
}
\description{
\code{peer.avg} computes peer average value using network data (as a list) and observable characteristics.
}
\examples{
# Generate a list of adjacency matrices
## sub-network size
N  <- c(250, 370, 120)  
## rate of friendship
p  <- c(.2, .15, .18)   
## network data
u  <- unlist(lapply(1: 3, function(x) rbinom(N[x]*(N[x] - 1), 1, p[x])))
G  <- vec.to.mat(u, N, normalise = TRUE)

# Generate a vector y
y  <- rnorm(sum(N))

# Compute G\%*\%y
Gy <- peer.avg(Glist = G, V = y)
}
\seealso{
\code{\link{simnetwork}}
}
