% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{add_end_user}
\alias{add_end_user}
\title{Add a CEDARS End User}
\usage{
add_end_user(
  uri_fun,
  user,
  password,
  host,
  port,
  database,
  end_user,
  end_user_password
)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{end_user}{CEDARS end user name.}

\item{end_user_password}{CEDARS end user password.}
}
\value{
{
Confirmation that requested operation was completed, or error message if attempt failed.
}
}
\description{
Adds an end user. Password must be at least 8 characters in length.
}
\examples{
\dontrun{
add_end_user(uri_fun = mongo_uri_standard, user = 'John', password = 'db_password_1234',
host = 'server1234', port = NA, database = 'TEST_PROJECT', end_user = 'Mike',
end_user_password = 'user_pw_5678')
}
}
