% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/distanceBasedLandscapeGenerators.R
\name{landscapeGeneratorMUL}
\alias{landscapeGeneratorMUL}
\title{Multimodal Fitness Landscape}
\usage{
landscapeGeneratorMUL(ref = list(1:10), distFun)
}
\arguments{
\item{ref}{list of reference individuals}

\item{distFun}{Distance function, used to evaluate d(x,ref[[n]]), where x is an arbitrary new individual}
}
\value{
returns a function. The function can take any type of individual as its input, depending on whether it is suitable for the distance function.
}
\description{
This function generates multi-modal fitness landscapes based on distance measures.
The fitness is the minimal distance to several reference individuals. Hence, each reference individual
is an optimum of the landscape.
}
\seealso{
\code{\link{landscapeGeneratorUNI}}, \code{\link{landscapeGeneratorGaussian}}

fun <- landscapeGeneratorMUL(ref=list(1:7,c(2,4,1,5,3,7,6)),distancePermutationCos)
x <- 1:7
fun(x)
x <- c(2,4,1,5,3,7,6)
fun(x)
x <- 7:1
fun(x)
x <- sample(7)
fun(x)
}

