% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretchPlot.R
\name{stretchPlot}
\alias{stretchPlot}
\alias{stretchPlot,RasterLayer-method}
\title{Contrast adjustments for RasterLayer plots}
\usage{
stretchPlot(x, type = "linear", n, ...)

\S4method{stretchPlot}{RasterLayer}(x, type = "linear", n, ...)
}
\arguments{
\item{x}{a RasterLayer}

\item{type}{character. Possible values are "linear", "hist.equal", and "sd"}

\item{n}{number of standard deviations to include if \code{type = "sd"}}

\item{...}{Additional arguments for raster::plot}
}
\value{
Returns a RasterLayer plot.
}
\description{
A plotting function that provides methods for improving the contrast
between values.
}
\details{
If \code{type = "hist.equal"}, a histogram equalization procedure will be
applied to the values of \code{x}. If \code{type = "sd"}, the values of
\code{x} will be scaled between values that fall between \code{n} standard
deviations of the mean.
}
\examples{
mod <- enfa(x = climdat.hist, s.dat = ABPR, field = "CODE")
sm <- sensitivity_map(mod)
stretchPlot(sm)
stretchPlot(sm, type = "hist.equal")
stretchPlot(sm, type = "sd", n = 2)

}
