% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lateonset.simu.R
\name{lateonset.simu}
\alias{lateonset.simu}
\title{Conduct one simulation using the calibration-free odds type (CFO-type) design with late-onset toxicity.}
\usage{
lateonset.simu(design, target, p.true, init.level = 1, ncohort, cohortsize,
       assess.window, tte.para, accrual.rate, accrual.dist,  
       prior.para = list(alp.prior = target, bet.prior = 1 - target), 
       cutoff.eli = 0.95, early.stop = 0.95, seed = NULL)
}
\arguments{
\item{design}{option for selecting different designs, which can be set as \code{'TITE-CFO'}, \code{'TITE-aCFO'},
\code{'fCFO'}, \code{'f-aCFO'}, \code{'bCFO'}, and \code{'b-aCFO'}. Specifically, \code{'bCFO'} refers
to the benchmark CFO design, and \code{'b-aCFO'} denotes the benchmark aCFO design.}

\item{target}{the target DLT rate.}

\item{p.true}{the true DLT rates under the different dose levels.}

\item{init.level}{the dose level assigned to the first cohort. The default value \code{init.level} is 1.}

\item{ncohort}{the total number of cohorts.}

\item{cohortsize}{the number of patients of each cohort.}

\item{assess.window}{the maximal assessment window size.}

\item{tte.para}{the parameter related with the distribution of the time to DLT events. The time to DLT is sampled from a Weibull
distribution, with \code{tte.para} representing the proportion of DLTs occurring within the first half of the
assessment window.}

\item{accrual.rate}{the accrual.rate rate, i.e., the number of patients accrued per unit time.}

\item{accrual.dist}{the distribution of the arrival times of patients. When \code{accrual.dist = 'fix'}, it corresponds to all
patients in each cohort arriving simultaneously at a given accrual rate. When \code{accrual.dist = 'unif'},
it corresponds to a uniform distribution, and when \code{accrual.dist = 'exp'}, it corresponds to an
exponential distribution.}

\item{prior.para}{the prior parameters for a beta distribution, where set as \code{list(alp.prior = target, bet.prior = 1 - target)}
by default, \code{alp.prior} and \code{bet.prior} represent the parameters of the prior distribution for
the true DLT rate at any dose level. This prior distribution is specified as Beta(\code{alpha.prior}, \code{beta.prior}).}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of \code{cutoff.eli = 0.95} for general use.}

\item{early.stop}{the threshold value for early stopping. The default value \code{early.stop = 0.95}
generally works well.}

\item{seed}{an integer to set as the seed of the random number generator for reproducible results. The default value is set to NULL.}
}
\value{
The \code{lateonset.simu()} function returns a list object comprising the following components:
\itemize{
\item target: the target DLT rate.
\item MTD: the selected MTD. \code{MTD = 99} indicates that this trial is terminated due to early stopping.
\item correct: a binary indicator of whether the recommended dose level matches the target DLT rate (1 for yes).
\item npatients: the total number of patients allocated to all dose levels
\item ntox: the total number of DLTs observed for all dose levels.
\item npercent: the percentage of subjects assigned to the target DLT rate.
\item over.doses: a vector indicating whether each dose is overdosed or not (1 for yes).
\item cohortdose: a vector including the dose level assigned to each cohort.
\item ptoxic: the percentage of subjects assigned to dose levels with a DLT rate greater than the target.
\item patientDLT: a vector including the DLT outcome observed for each patient.
\item sumDLT: the total number of DLT observed.
\item earlystop: a binary indicator of whether the trial is early stopped (1 for yes).
\item totaltime: the duration of the trial.
\item entertimes: the time that each participant enters the trial.
\item DLT.times: the time to DLT for each subject in the trial. If no DLT occurs for a certain subject,
\code{DLT.times} is 0.
}
}
\description{
The function is used to conduct one single simulation and find the maximum tolerated dose (MTD) for the CFO-type designs with late-onset toxicities,
specifically, including time-to-event CFO (TITE-CFO) design, fractional CFO (fCFO) design, benchmark CFO design,
time-to-event accumulative CFO (TITE-aCFO) design, fractional accumulative CFO (f-aCFO) design and benchmark aCFO design.
}
\note{
The early stopping and dose elimination rules are incorporated into the design
to ensure patient safety and benefit.
}
\examples{
target <- 0.2; ncohort <- 12; cohortsize <- 3; init.level <- 1
p.true <- c(0.01, 0.07, 0.20, 0.35, 0.50, 0.65, 0.80)
assess.window <- 3; accrual.rate <- 2; tte.para <- 0.5; accrual.dist <- 'unif'
## find the MTD for a single TITE-CFO simulation
TITECFOtrial <- lateonset.simu (design = 'TITE-CFO', target, p.true, init.level,  
                ncohort, cohortsize, assess.window, tte.para, accrual.rate, accrual.dist, seed = 1)
summary(TITECFOtrial)
plot(TITECFOtrial)
## find the MTD for a single TITE-aCFO simulation
TITEaCFOtrial <- lateonset.simu (design = 'TITE-aCFO', target, p.true, init.level,  
                ncohort, cohortsize, assess.window, tte.para, accrual.rate, accrual.dist, seed = 1)
summary(TITEaCFOtrial)
plot(TITEaCFOtrial)
## find the MTD for a single fCFO simulation
fCFOtrial <- lateonset.simu (design = 'fCFO', target, p.true, init.level,  
                ncohort, cohortsize, assess.window, tte.para, accrual.rate, accrual.dist, seed = 1)
summary(fCFOtrial)
plot(fCFOtrial)
## find the MTD for a single f-aCFO simulation
faCFOtrial <- lateonset.simu (design = 'f-aCFO', target, p.true, init.level,  
                ncohort, cohortsize, assess.window, tte.para, accrual.rate, accrual.dist, seed = 1)
summary(faCFOtrial)
plot(faCFOtrial)
}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
Jin H, Yin G (2023). Time‐to‐event calibration‐free odds design: A robust efficient design for
phase I trials with late‐onset outcomes. \emph{Pharmaceutical Statistics}. 22(5), 773–783.\cr
Yin G, Zheng S, Xu J (2013). Fractional dose-finding methods with late-onset toxicity in
phase I clinical trials. \emph{Journal of Biopharmaceutical Statistics}, 23(4), 856-870. \cr
Fang J, Yin G (2024). Fractional accumulative calibration‐free odds (f‐aCFO) design for delayed toxicity
in phase I clinical trials. \emph{Statistics in Medicine}.
}
\author{
Jialu Fang, Wenliang Wang, and Guosheng Yin
}
