% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFformat.R
\name{CFtimestamp}
\alias{CFtimestamp}
\title{Create a vector of character strings that represent CF timestamps}
\usage{
CFtimestamp(cf, format = NULL)
}
\arguments{
\item{cf}{CFtime. The \code{CFtime} instance that contains the offsets to use.}

\item{format}{character. An atomic string with either of the values "date",
"time", "timestamp". If the argument is not specified, the format used is
"timestamp" if there is time information, "date" otherwise.}
}
\value{
A character vector where each element represents a moment in time
according to the \code{format} specifier. Time zone information is not represented.
}
\description{
This function generates a vector of character strings that represent the date
and/or time in a selectable combination for each offset.
}
\details{
The character strings use the format \verb{YYYY-MM-DDThh:mm:ss±hh:mm}, depending
on the \code{format} specifier. The date in the string is not necessarily
compatible with \code{POSIXt} - in the \verb{360_day} calendar \code{2017-02-30} is valid
and \code{2017-03-31} is not.
}
\examples{
cf <- CFtime("hours since 2020-01-01", "standard", seq(0, 24, by = 0.25))
CFtimestamp(cf, "timestamp")

cf2 <- CFtime("days since 2002-01-21", "standard", 0:20)
tail(CFtimestamp(cf2))

tail(CFtimestamp(cf2 + 1.5))
}
