% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFtime.R
\name{CFcomplete}
\alias{CFcomplete}
\title{Indicates if the time series is complete}
\usage{
CFcomplete(x)
}
\arguments{
\item{x}{An instance of the \code{CFtime} class}
}
\value{
logical. \code{TRUE} if the time series is complete, with no gaps;
\code{FALSE} otherwise. If no offsets have been added to the CFtime instance,
\code{NA} is returned.
}
\description{
This function indicates if the time series is complete, meaning that the time
steps are equally spaced and there are thus no gaps in the time series.
}
\details{
This function gives exact results for time series where the nominal
\emph{unit of separation} between observations in the time series is exact in terms of the
datum unit. As an example, for a datum unit of "days" where the observations
are spaced a fixed number of days apart the result is exact, but if the same
datum unit is used for data that is on monthly a basis, the \emph{assessment} is
approximate because the number of days per month is variable and dependent on
the calendar (the exception being the \verb{360_day} calendar, where the
assessment is exact). The \emph{result} is still correct in most cases (including
all CF-compliant data sets that the developers have seen) although
there may be esoteric constructions of CFtime and offsets that trip up this
implementation.
}
\examples{
cf <- CFtime("days since 1850-01-01", "julian", 0:364)
CFcomplete(cf)
}
