% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot2WayANOVA.R
\name{Plot2WayANOVA}
\alias{Plot2WayANOVA}
\title{Plot a 2 Way ANOVA using dplyr and ggplot2}
\usage{
Plot2WayANOVA(formula, dataframe = NULL, confidence=.95,
    plottype = "bar", xlab = NULL, ylab = NULL, title = NULL,
    subtitle = NULL, interact.line.size = 2, mean.plotting = FALSE,
    mean.ci = TRUE, mean.size = 4, mean.color = "darkred",
    mean.label.size = 3, mean.label.color = "black", overlay.type = NULL,
    PlotSave = FALSE)
}
\arguments{
\item{formula}{a formula with a numeric dependent (outcome) variable, 
and two independent (predictor) variables e.g. \code{mpg ~ am * vs}.
The independent variables are coerced to factors (with warning) if 
possible.}

\item{dataframe}{a dataframe or an object that can be coerced to a dataframe}

\item{confidence}{what confidence level for confidence intervals}

\item{plottype}{bar or line (quoted)}

\item{xlab, ylab}{Labels for `x` and `y` axis variables. If `NULL` (default),
variable names for `x` and `y` will be used.}

\item{title}{The text for the plot title. A generic default is provided.}

\item{subtitle}{The text for the plot subtitle. If `NULL` (default), key
model information is provided as a subtitle.}

\item{interact.line.size}{Line size for the line connecting the group means
(Default: `2`).}

\item{mean.plotting}{Logical that decides whether the value of the group 
mean is to be displayed (Default: `FALSE`).}

\item{mean.ci}{Logical that decides whether the confidence interval for 
group means is to be displayed (Default: `TRUE`).}

\item{mean.size}{Point size for the data point corresponding to mean
(Default: `4`).}

\item{mean.color}{Color for the data point corresponding to mean (Default:
`"darkred"`).}

\item{mean.label.size, mean.label.color}{Aesthetics for
the label displaying mean. Defaults: `3`, `"black"`, respectively.}

\item{overlay.type}{A character string (e.g., `"box"` or `"violin"`), 
if you wish to overlay that information on factor1}

\item{PlotSave}{a logical indicating whether the user wants to save the plot
as a png file}
}
\value{
A list with 5 elements which is returned invisibly. These items
  are always sent to the console for display but for user convenience 
  the function also returns a named list with the following items
  in case the user desires to save them or further process them -
  \code{$ANOVATable},\code{$ModelSummary}, \code{$MeansTable}, 
  \code{$BFTest}, and \code{$SWTest}.
  The plot is always sent to the default plot device
}
\description{
Takes a formula and a dataframe as input, conducts an analysis of variance
prints the results (AOV summary table, table of overall model information 
and table of means) then uses ggplot2 to plot an interaction graph (line 
or bar) .  Also uses Brown-Forsythe test for homogeneity of
variance.  Users can also choose to save the plot out as a png file.
}
\details{
Details about how the function works in order of steps taken.
\enumerate{
\item Some basic error checking to ensure a valid formula and dataframe.
  Only accepts fully *crossed* formula to check for interaction term
\item Ensure the dependent (outcome) variable is numeric and that the two
  independent (predictor) variables are or can be coerced to factors -- user
  warned on the console
\item Remove missing cases -- user warned on the console
\item Calculate a summarized table of means, sds, standard errors of the
   means, confidence intervals, and group sizes.
\item Use \code{\link[stats]{aov}} function to execute an Analysis of 
  Variance (ANOVA)
\item Use \code{\link[sjstats]{anova_stats}} to calculate eta squared 
  and omega squared values per factor. If the design is unbalanced warn  
  the user and use Type II sums of squares
\item Produce a standard ANOVA table with additional columns 
\item Use the \code{\link[car]{leveneTest}} for testing Homogeneity 
  of Variance assumption with Brown-Forsythe
\item Use the \code{\link[stats]{shapiro.test}} for testing normality
  assumption with Shapiro-Wilk
\item Use \code{ggplot2} to plot an interaction plot of the type the 
  user specified.}
The defaults are deliberately constructed to emphasize the nature
  of the interaction rather than focusing on distributions. So
  while a violin plot of the first factor by level is displayed
  along with dots for individual data points shaded by the second 
  factor, the emphasis is on the interaction lines.
}
\examples{

Plot2WayANOVA(mpg ~ am * cyl, mtcars, plottype = "line")
Plot2WayANOVA(mpg ~ am * cyl, 
              mtcars, 
              plottype = "line", 
              overlay.type = "box", 
              mean.plotting = TRUE)
Plot2WayANOVA(mpg ~ am * vs, mtcars, confidence = .99)
}
\seealso{
\code{\link[stats]{aov}}, \code{\link[car]{leveneTest}},
\code{\link[sjstats]{anova_stats}}, \code{\link[stats]{replications}},
\code{\link[stats]{shapiro.test}}
}
\author{
Chuck Powell
}
