% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{giant_component_extract}
\alias{giant_component_extract}
\title{Giant component extraction of a graph}
\usage{
giant_component_extract(x, directed = TRUE, bipartite_proj = FALSE,
  num_proj = 1)
}
\arguments{
\item{x}{An igraph or a network object}

\item{directed}{Whether to create a directed graph(default=TRUE)}

\item{bipartite_proj}{Whether the bipartite network must be projected or not(default=FALSE)}

\item{num_proj}{A number which shows the number of projects especifically for
bipartite graphs.(default=1)}
}
\value{
a list contatining the giant componet of the input graph. The first element is an igraph object and the second is the edgelist of that.
}
\description{
This function extracts the largest connected or the giant component
of the input graph which can be an "igraph" object or a "network" object
and convert them as "igraph" objects. For the bipartite graph, this will
apply projection before extracting the components.
}
\details{
This function distinguishes the largest component of an "igraph" or a "network" object and
illustrates them as a list which contains the edgelist of the giant component. If the input
graph was bipartite and the "bipartite_proj" was TRUE, it will projet it and you can decide
to which project you want to continue to work with that.
}
\examples{
# a graph with 4 vertices

data(zachary)
giant_component_extract(zachary)

}
\references{
Newman, M. (2010). Networks. Oxford University Press.
}
\seealso{
\code{\link[igraph]{induced.subgraph}},\code{\link[igraph]{clusters}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
