% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3generics_clvdata.R,
%   R/f_s3generics_clvdata_dynamiccov.R, R/f_s3generics_clvdata_staticcov.R
\name{summary.clv.data}
\alias{summary.clv.data}
\alias{print.summary.clv.data}
\alias{summary.clv.data.dynamic.covariates}
\alias{print.summary.clv.data.dynamic.covariates}
\alias{summary.clv.data.static.covariates}
\alias{print.summary.clv.data.static.covariates}
\title{Summarizing a CLV data object}
\usage{
\method{summary}{clv.data}(object, ...)

\method{print}{summary.clv.data}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{summary}{clv.data.dynamic.covariates}(object, ...)

\method{print}{summary.clv.data.dynamic.covariates}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{summary}{clv.data.static.covariates}(object, ...)

\method{print}{summary.clv.data.static.covariates}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{A CLV data object containing transactional data and potentially also contextual factors.}

\item{...}{Ignored.}

\item{x}{An object of class \code{"summary.clv.data"}, usually, a result of a call to \code{summary.clv.data}.}

\item{digits}{The number of significant digits to use when printing.}
}
\value{
This function computes and returns summary statistics of the
transactional and covariates data given in \code{object}. This is a list of
class \code{summary.clv.data} and contains the elements:
\item{name}{Human readable description of the type of data.}
\item{summary.clv.tim}{Summary information about the stored \code{clv.time} object.}
\item{descriptives.transactions}{A \code{data.table} with summary statistics of
the transactions overall and in the estimation and holdout sample.}

For static covariates data, the list additionally is of class \code{summary.clv.data.static.covariates}
and further contains the elements:

\item{names.cov.data.trans}{Names of the covariates for the Transaction process.}
\item{names.cov.data.life}{Names of the covariates for the Lifetime process.}
}
\description{
Summary method for objects of class \code{clv.data} that provides information about the estimation and
possible holdout sample, and descriptive statistics of the transaction data.
}
\examples{

\donttest{

data("apparelTrans")
clv.data.apparel <- clvdata(apparelTrans, date.format = "ymd",
                            time.unit = "w",
                            estimation.split = 40)

# summary of transaction data and split
summary(clv.data.apparel)

# add contextual factors
data("apparelStaticCov")
clv.data.apparel.cov <-
 SetStaticCovariates(clv.data.apparel,
                     data.cov.life = apparelStaticCov,
                     names.cov.life = "Gender",
                     data.cov.trans = apparelStaticCov,
                     names.cov.trans = "Gender")

# additional info about the covariates
summary(clv.data.apparel.cov)
}

}
\seealso{
\code{\link[CLVTools:plot.clv.data]{plot}} for how to plot a clv data object

\code{\link[CLVTools:clvdata]{clvdata}} for how to create a clv data object

\code{\link[CLVTools:SetStaticCovariates]{SetStaticCovariates}} for how to add static covariates

\code{\link[CLVTools:SetDynamicCovariates]{SetDynamicCovariates}} for how to add dynamic covariates
}
\keyword{internal}
