% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_row_col_effects.R
\name{row_col_effect}
\alias{row_col_effect}
\title{Row and column effects}
\usage{
row_col_effect(to_align, rows, cols)
}
\arguments{
\item{to_align}{a numeric response vector.}

\item{rows}{a vector giving the row effects for \code{y}.}

\item{cols}{a vector giving the column effects for \code{y}.}
}
\value{
A vector of row and column effects. The response vector less this is
the aligned response variable.
}
\description{
\code{row_col_effects} returns the values of the row and column effects. This
can be used to remove these effects from the response in a process call
aligning. This is particularly applicable in LSD data.
}
\examples{
attach(peanuts)
row_col_effect(to_align = yield, rows = row, cols = col)
}
\references{
Rayner, J.C.W and Livingston, G. C. (2022). An Introduction to Cochran-Mantel-Haenszel Testing and Nonparametric ANOVA. Wiley.
}
