% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_lv_switchgear_and_other.R
\name{environmental_cof_lv_switchgear_and_other}
\alias{environmental_cof_lv_switchgear_and_other}
\title{Environmental cost of Failure for LV swicthgear and others}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
environmental_cof_lv_switchgear_and_other(lv_asset_category)
}
\arguments{
\item{lv_asset_category}{String The type of LV asset category}
}
\description{
This function calculates environmental consequences of failure
(cf. section 7.3, page 75, CNAIM, 2017). Environmental consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().#' @return Numeric. Financial consequences of failure for LV switchgear
}
\examples{
environmental_cof_lv_switchgear_and_other(lv_asset_category = "LV Board (WM)")
}
