% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_sub_cables.R
\name{network_cof_hv_sub_cables}
\alias{network_cof_hv_sub_cables}
\title{Network cost of Failure for HV Sub cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
network_cof_hv_sub_cables(
  sub_cable_asset_category,
  no_customers,
  kva_per_customer = "Default"
)
}
\arguments{
\item{sub_cable_asset_category}{String The type of Submarine cable asset category
Option: \code{sub_cable_asset_category = "HV Sub Cable"}.}

\item{no_customers}{Numeric. The number of customers
fed by an individual asset.}

\item{kva_per_customer}{Numeric. If the asset have an exceptionally high
demand per customer type in kVA per customer. A setting of \code{"Default"}
results in a multiplication factor of 1 (cf. table 18, page 89, CNAIM, 2021).}
}
\value{
Numeric. Network cost of failure.
}
\description{
This function calculates network cost of failure for
Sub cables
(cf. section 7.6, page 87, CNAIM, 2021). Network cost of failure
is used in the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
network_cof_hv_sub_cables(sub_cable_asset_category = "HV Sub Cable",
no_customers = 750, kva_per_customer = 51)
}
