% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_cables_04_10kv.R
\name{network_cof_cables_04_10kv}
\alias{network_cof_cables_04_10kv}
\title{Network cost of Failure for 0.4kV and 10kV UG Cables}
\usage{
network_cof_cables_04_10kv(hv_asset_category, actual_load_mva, secure = T)
}
\arguments{
\item{hv_asset_category}{String The type of HV asset category}

\item{actual_load_mva}{Numeric. The actual load on the asset}

\item{secure}{Boolean If the asset is in a secure network or not}
}
\value{
Numeric. Network cost of failure.
}
\description{
This function calculates network cost of failure for
0.4kV and 10kV UG cables, outputted in DKK
\code{hv_asset_category = c("10kV UG Cable (Oil)",
"10kV UG Cable (Non Pressurised)", "0.4kV UG Cable (Non Pressurised)"}.
}
\examples{
network_cof_cables_04_10kv(hv_asset_category = "10kV UG Cable (Oil)",
actual_load_mva = 15)
}
