% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_compare.R
\name{compTableMulti}
\alias{compTableMulti}
\title{Rank tables between multiple COINs}
\usage{
compTableMulti(
  COINs,
  dset = "Aggregated",
  isel = "Index",
  tabtype = "Ranks",
  ibase = 1,
  sort_table = TRUE,
  extra_cols = NULL
)
}
\arguments{
\item{COINs}{A list of COINs}

\item{dset}{The data set to extract the indicator from (must be present in each COIN). Default \code{"Aggregated"}.}

\item{isel}{Code of the indicator or aggregate to extract from each COIN (must be present in the specified
data set of each COIN). Default \code{"Index"}.}

\item{tabtype}{The type of table to generate - \code{"Ranks"}, \code{"Diffs"}, or \code{"AbsDiffs"}.}

\item{ibase}{The index of the COIN to use as a base comparison}

\item{sort_table}{If TRUE, sorts by the base COIN (\code{ibase}) (default).}

\item{extra_cols}{A character vector of any extra columns to include from the COIN referenced by \code{ibase}. For example,
this could include group columns.}
}
\value{
Rank comparison table as a data frame
}
\description{
Takes multiple COINs (two or more), and generates a rank comparison for a single indicator or aggregate.
}
\examples{
ASEM <- build_ASEM()
# Make a copy
ASEMAltNorm <- ASEM
# Edit .$Method
ASEMAltNorm$Method$normalise$ntype <- "borda"
# Regenerate
ASEMAltNorm <- COINr::regen(ASEMAltNorm, quietly = TRUE)
# compare
ctable <- compTableMulti(list(ASEM, ASEMAltNorm), dset = "Aggregated", isel = "Index")

# add more COINs to the list to see more cols in the table...

}
\seealso{
\itemize{
\item \code{\link[=compTable]{compTable()}} Comparison table between two COINs
}
}
