% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_rew8r.R
\name{weightOpt}
\alias{weightOpt}
\title{Weight optimisation}
\usage{
weightOpt(
  COIN,
  itarg,
  aglev,
  cortype = "pearson",
  optype = "balance",
  toler = NULL,
  maxiter = NULL,
  out2 = NULL
)
}
\arguments{
\item{COIN}{COIN object}

\item{itarg}{a vector of (relative) target importances. For example, \code{c(1,2,1)} would specify that the second
indicator should be twice as "important" as the other two.}

\item{aglev}{The aggregation level to apply the weight adjustment to.}

\item{cortype}{The type of correlation to use - can be either \code{"pearson"}, \code{"spearman"} or \code{"kendall"}. See \link[stats:cor]{stats::cor}.}

\item{optype}{The optimisation type. Either \code{"balance"}, which aims to balance correlations
according to a vector of "importances" specified by \code{itarg} (default), or \code{"infomax"} which aims to maximise
overall correlations. \emph{This latter option is experimental and may not yet work very well}.}

\item{toler}{Tolerance for convergence. Defaults to 0.001 (decrease for more accuracy, increase if convergence problems).}

\item{maxiter}{Maximum number of iterations. Default 500.}

\item{out2}{Where to output the results. If \code{"COIN"} (default for COIN input), appends to updated COIN,
creating a new list of weights in \code{.$Parameters$Weights}. Otherwise if \code{"list"} outputs to a list (default).}
}
\value{
If \code{out2 = "COIN"} returns an updated COIN object with a new set of weights in \code{.$Parameters$Weights}, plus
details of the optimisation in \code{.$Analysis}.
Else if \code{out2 = "list"} the same outputs (new weights plus details of optimisation) are wrapped in a list.
}
\description{
This function provides optimised weights to agree with a pre-specified vector of "target importances".
}
\details{
This is a linear version of the weight optimisation proposed in this paper: \doi{10.1016/j.ecolind.2017.03.056}.
Weights are optimised to agree with a pre-specified vector of "importances". The optimised weights are returned back to the COIN.

See the \href{https://bluefoxr.github.io/COINrDoc/weighting-1.html#automatic-re-weighting}{chapter in the COINr online documentation}
for more details.
}
\examples{
# build ASEM COIN up to aggregation
ASEM <- build_ASEM()
# optimise sub-pillar weights to give equal correlations with index
ASEM <- weightOpt(ASEM, itarg = "equal", aglev = 3, out2 = "COIN")

}
\seealso{
\itemize{
\item \code{\link[=rew8r]{rew8r()}} Interactive app for adjusting weights and seeing effects on correlations
\item \code{\link[=getPCA]{getPCA()}} PCA, including weights from PCA
}
}
