% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_indplot.R
\name{plotIndDist}
\alias{plotIndDist}
\title{Static indicator distribution plots}
\usage{
plotIndDist(
  COINobj,
  dset = "Raw",
  icodes = NULL,
  aglev = 1,
  type = "Box",
  ntype = NULL,
  npara = NULL
)
}
\arguments{
\item{COINobj}{The COIN object, or a data frame of indicator data}

\item{dset}{The source data set to use for indicator data (if input is COIN object)}

\item{icodes}{A character vector of indicator names to plot. Defaults to all indicators.}

\item{aglev}{The aggregation level to extract the indicator data from. Defaults to indicator level (1).}

\item{type}{The type of plot. Currently supported \code{"Box"}, \code{"Dot"}, \code{"Violin"}, \code{"Violindot"}, \code{"Histogram"}.}

\item{ntype}{The type of normalisation to apply. If \code{NULL}, no normalisation applied, otherwise specify
using \code{ntype} options in \code{\link[=normalise]{normalise()}}.}

\item{npara}{Optional parameters to pass to \code{\link[=normalise]{normalise()}} if normalisation required.}
}
\value{
Plots generated with \strong{ggplot2}. These can be edited further with \strong{ggplot2} commands.
}
\description{
Plots indicator distributions using box plots, dot plots, violin plots, violin-dot plots, and histograms.
Supports plotting multiple indicators by calling aggregation groups.
}
\details{
This function also optionally normalises indicators so they can be compared more easily side by side. For this
purpose it calls \code{\link[=normalise]{normalise()}} - see \code{ntype} and \code{npara} arguments.

See \href{https://bluefoxr.github.io/COINrDoc/initial-visualisation-and-analysis.html#distributions}{COINr online documentation} and \code{\link[=getIn]{getIn()}} for more information on accessing/plotting groups.
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# plot indicators in Physical pillar
plotIndDist(ASEM, type = "Box", dset = "Raw", icodes = "Physical")

}
